% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SMR_interval.R
\name{SMR_interval}
\alias{SMR_interval}
\title{Interval Estimates for Summary Data Mendelian Randomization Analysis in the Presence of Winner's Curse}
\usage{
SMR_interval(
  summary.data,
  sig.level = 5e-08,
  k = 2,
  alpha = 0.05,
  method = "box"
)
}
\arguments{
\item{summary.data}{a vector (\eqn{\hat b_{gx}}, se(\eqn{\hat b_{gx}}), \eqn{\hat b_{gy}}, se(\eqn{\hat b_{gy}})) of summary data on the exposure \eqn{X} and the outcome \eqn{Y}. Due to winner's curse, the association \eqn{p}-value between the SNP and the exposure is less than \code{sig.level}.}

\item{sig.level}{the threshold \eqn{p}-value used to select the instrument SNP. The default is \code{5e-8}.}

\item{k}{the unit used for the k-unit support. The default value is 2.}

\item{alpha}{\eqn{(1-\alpha)} is the conservative coverage level for the box method interval or the SMR Wald interval. the default value is 0.05}

\item{method}{method to construct the interval. It is either "\code{support}", "\code{box}" or "\code{wald}". The default is "\code{box}".}
}
\value{
The returned value is method-dependent.

For \code{method == "box"}: A list containing the following components:

* an interval estimate.

* type of the interval: completely bounded, exclusive bounded, or bounded.

For \code{method == "support"}: A list containing the following components:

* Estimate The likelihood estimate of \eqn{b}.

* an interval estimate.

For \code{method == "wald"}: an interval estimate.
}
\description{
\code{SMR_interval} calculates conservative box method interval, k-unit support interval, and Wald confidence interval for the causal effect. 
  
%% ~~ If necessary, more details than the description above ~~
}
\examples{
summary.data = c(0.13707, 0.0235162, -0.0637257, 0.013774)
SMR_interval(summary.data)
SMR_interval(summary.data, method = "support")
SMR_interval(summary.data, method = "wald")

}
\references{
Wang, K. (2023) Support interval for two-sample summary data-based mendelia randomization. \emph{Genes}, 14(1):211.

Wang, K. (2023) Interval estimate of causal effect in summary data based Mendelian randomization in the presence of winner’s curse. \emph{Genetic Epidemiology}, 14(1):211.

Zhu, Z. et al. (2016) Integration of summary data from GWAS and eQTL studies predicts complex trait gene targets. \emph{Nature Genetics}, 48(5):481.
}
\author{
Kai Wang \code{<kai-wang@uiowa.edu>}
}
