% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cor_plot.R
\name{cor_plot}
\alias{cor_plot}
\title{Correlation Plot with Significance Points}
\usage{
cor_plot(
  data1,
  data2,
  sig.name1 = "value1",
  sig.name2 = "value2",
  cutoff.pvalue = 0.05,
  color = c("#62CCC9", "#FF9999")
)
}
\arguments{
\item{data1}{A data frame or matrix representing the first dataset.}

\item{data2}{A data frame or matrix representing the second dataset.}

\item{sig.name1}{A character string specifying the name of the first dataset (default: "value1").}

\item{sig.name2}{A character string specifying the name of the second dataset (default: "value2").}

\item{cutoff.pvalue}{The significance threshold for correlation (default: 0.05).}

\item{color}{A vector of two colors for the heatmap gradient (default: c("#62CCC9", "#FF9999")).}
}
\value{
A ggplot object displaying the correlation heatmap and scatter points.
}
\description{
This function generates a correlation plot between two datasets, displaying correlation coefficients as a heatmap and significant correlations as scatter points.
}
\details{
The function computes correlation coefficients between corresponding columns in the two datasets and identifies significant correlations based on p-values.
}
\examples{
# Read all data into memory
data(data.path, package = "iPRISM")
data(data.cell, package = "iPRISM")
# Draw the plot
cor_plot(data1 = data.path,data2 = data.cell,sig.name1 = "path",sig.name2 = "cell")

}
\keyword{correlation}
\keyword{ggplot}
\keyword{heatmap}
\keyword{plot}
\keyword{scatter}
