% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/false_ring_proportion.R
\name{novak_index}
\alias{novak_index}
\title{novak_index}
\usage{
novak_index(iadf, model, po = NULL, method = "difference")
}
\arguments{
\item{iadf}{A data frame with numeric columns representing individual series
and years as rownames where years with IADF are marked binary with 1,
those without with 0, years not covered by the series are set to NA.}

\item{model}{a model, output of either  \code{\link[iadf]{novak_weibull}}}

\item{po}{an optional data frame of pith offsets with series names in the
first and pith offsets in the second column}

\item{method}{method for the RCS detrending, 'quotient' or 'difference'}
}
\value{
a data frame
}
\description{
Calculation of age corrected IADF frequencies according
  to Novak et al. (2013).
}
\examples{
data('example_iadf')
model <- novak_weibull(novak_freq(example_iadf), 15)
novak_index(example_iadf, model)
}
\references{
Novak, Klemen and Sánchez, Miguel Angel Saz and Čufar, Katarina and
  Raventós, Josep and de Luis, Martin.  Age, climate and intra-annual density
  fluctuations in in Spain, IAWA Journal, 34, 459-474 (2013),
  doi:10.1163/22941932-00000037
}
\seealso{
\code{\link{novak_freq}}, \code{\link{novak_weibull}}
}
