% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getData.R
\name{getTraits}
\alias{getTraits}
\title{Getting Traits Associated with Crops from the ICARDA's Genebank Documentation System}
\usage{
getTraits(crop)
}
\arguments{
\item{crop}{character. Crop for which to get available traits.}
}
\value{
A data frame with traits that are associated with the crop specified in \code{crop}.
}
\description{
Return a data frame containing traits associated with a particular crop, their description and related identifiers.
}
\details{
\code{getTraits} returns a data frame of traits together with their IDs and coding system used for each trait.

Possible inputs for \code{crop} include:
\itemize{
  \item{'Aegilops'}
  \item{'Barley'}
  \item{'Bread wheat'}
  \item{'Chickpea'}
  \item{'Durum wheat'}
  \item{'Faba bean'}
  \item{'Faba bean BPL'}
  \item{'Forage and range'}
  \item{'Lathyrus'}
  \item{'Lentil'}
  \item{'Medicago annual'}
  \item{'Not mandate cereals'}
  \item{'Pisum'}
  \item{'Primitive wheat'}
  \item{'Trifolium'}
  \item{'Vicia'}
  \item{'Wheat hybrids'}
  \item{'Wheat wild relatives'}
  \item{'Wild Cicer'}
  \item{'Wild Hordeum'}
  \item{'Wild Lens'}
  \item{'Wild Triticum'}
 }

 A list of available crops to use as input for \code{crop} can also be obtained from ICARDA's online server using \code{\link[icardaFIGSr]{getCrops}}.
}
\examples{
if(interactive()){
 # Get traits for bread wheat
 breadTraits <- getTraits(crop = 'Bread wheat')
}
}
\author{
Khadija Aouzal, Amal Ibnelhobyb, Zakaria Kehel, Fawzy Nawar
}
