% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oanda.R
\name{oanda_set_key}
\alias{oanda_set_key}
\title{Set OANDA fxTrade API Key}
\usage{
oanda_set_key()
}
\value{
Invisible NULL. A key is set in the default keyring under the service
    name 'OANDA_API_KEY' for practice accounts or 'OANDA_LIVE_KEY' for live
    accounts.
}
\description{
Save OANDA fxTrade API key (personal access token) to the system credential
    store.
}
\details{
The key is read interactively. Separate keys can be set for practice
    and live accounts - please choose the correct account type when prompted.

    This function only needs to be called once to set the key; it does not
    need to be called each session.

    This function has a dependency on the 'keyring' package.
}
\section{Further Details}{

    Please refer to the OANDA fxTrade API vignette by calling:
    \code{vignette("xoanda", package = "ichimoku")}.
}

\examples{
if (interactive()) {
# Only run example in interactive R sessions
oanda_set_key()
}

}
