% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{print.ichimoku}
\alias{print.ichimoku}
\title{Print Ichimoku Objects}
\usage{
\method{print}{ichimoku}(x, plot = TRUE, rows = 26L, ...)
}
\arguments{
\item{x}{an object of class \sQuote{ichimoku}.}

\item{plot}{[default TRUE] set to FALSE to prevent automatic plotting of
the ichimoku cloud chart.}

\item{rows}{[default 26L] integer number of rows to print.}

\item{...}{additional arguments passed along to the xts print and
\code{\link{plot.ichimoku}} methods.}
}
\value{
The ichimoku object supplied (invisibly). The data is printed to the
    console. The ichimoku cloud chart is also output to the graphical device
    depending on the parameters set.
}
\description{
Default print method for ichimoku objects to enable automatic plotting of the
    ichimoku cloud chart.
}
\details{
This function is an S3 method for the generic function print() for
    class \sQuote{ichimoku}. It can be invoked by calling print(x) on an
    object \sQuote{x} of class \sQuote{ichimoku}.
}
\examples{
cloud <- ichimoku(sample_ohlc_data, ticker = "TKR")

print(cloud)
print(cloud, plot = FALSE, rows = 20L)

}
