% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IdeamLong.R
\name{IdeamLong}
\alias{IdeamLong}
\title{Create a day by day IDEAM's data serie}
\usage{
IdeamLong(file, write = FALSE, outfile = "MatrizIdeamLarga")
}
\arguments{
\item{file}{IDEAM file path or file name if it is on the working directory}

\item{write}{If True a CSV file is returned to the working directory, otherwise
only a data frame is shown}

\item{outfile}{Outfile name that will be saved on the working directory}
}
\value{
dataframe or a CSV file
}
\description{
Create a data frame with one value by row. The df is available to export as
a CSV file
}
\examples{
# Retreive example dataset
Example_IDEAM <- system.file("extdata", "Example_IDEAM", package = "ideamdb")
# Create a temporal file
example.ideam.long <- tempfile()
write.csv(IdeamLong(Example_IDEAM), file = example.ideam.long)
read.csv(example.ideam.long)

}
