% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_CHAMP_map.R
\name{get_CHAMP_map}
\alias{get_CHAMP_map}
\title{Find the SBM-equivalence iterative map on the CHAMP set of somewhere optimal partitions}
\usage{
get_CHAMP_map(network, partitions, plotlabel = NULL, shiny = FALSE)
}
\arguments{
\item{network}{The network, as igraph object, to be clustered into communities. Only undirected networks are currently supported. If the object has a 'weight' edge attribute, then that attribute will be used, though it is important to emphasize that the underlying equivalence between modularity and planted partitons defining the iterative map was derived for unweighted networks.}

\item{partitions}{List of unique partitions with CHAMP summary generated by \code{CHAMP}.}

\item{plotlabel}{Optional label to include as annotation on the generated figure.}

\item{shiny}{A logical value indicating whether \code{get_CHAMP_map} is being called within \code{ideanetViz}. If \code{TRUE}, \code{get_CHAMP_map} returns an output data frame that \code{ideanetViz} uses for visualization.}
}
\value{
\code{get_CHAMP_map} returns the input list of partitions with the \code{$CHAMPsummary} updated to indicate the iterative map, that is, information about the next partition that each partition points to in the map, along with the generated \code{$CHAMPmap} plot of the partitions in the CHAMP set (by their numbers of communities) versus gamma. If \code{shiny = TRUE}, the returned list also includes a data frame entitled \code{shiny_partitions} that is used for visualizations in \code{ideanetViz}.
}
\description{
\code{get_CHAMP_map} calculates the iterative map defined by Newman's equivalence between modularity optimization and inference on the degree-corrected planted partition stochastic block model on a \cite{CHAMP} set of partitions. That is, given an input set of partitions of nodes in a network into communities, calculated by \cite{get_partitions} or by other means and coerced into that format, \code{CHAMP} identifies which input partition is optimal at each value of the resolution parameter, gamma, and then \code{get_CHAMP_map} calculates the iterative map of this set onto itself. Importantly, a fixed point of this map, where a partition points to itself, indicates that partition is self-consistent in the sense of this equivalence between modularity and planted partition models. As with \code{CHAMP}, the \code{get_CHAMP_map} code is deterministic and fast given a specified input set of partitions; that is, all of the computational complexity and pseudo-stochastic heuristic nature of community detection is in identifying a good input set in \cite{get_partitions}.

The \code{CHAMP} method was developed and studied in Weir, William H., Scott Emmons, Ryan Gibson, Dane Taylor, and Peter J. Mucha. “Post-Processing Partitions to Identify Domains of Modularity Optimization.” Algorithms 10, no. 3 (August 19, 2017): 93. \doi{10.3390/a10030093}.

The equivalence between modularity optimization and planted partition inference was derived by M. E. J. Newman in “Equivalence between Modularity Optimization and Maximum Likelihood Methods for Community Detection.” Physical Review E 94, no. 5 (November 22, 2016): 052315. \doi{10.1103/PhysRevE.94.052315}.

The iterative map on the CHAMP set was developed and studied in Gibson, Ryan A., and Peter J. Mucha. “Finite-State Parameter Space Maps for Pruning Partitions in Modularity-Based Community Detection.” Scientific Reports 12, no. 1 (September 23, 2022): 15928. \doi{10.1038/s41598-022-20142-6}.

See also \url{https://github.com/wweir827/CHAMP} and \url{https://github.com/ragibson/ModularityPruning}.
}
\examples{
# Use get_partitions, CHAMP, and get_CHAMP_map to generate
# multiple partitions of the Zachary karate club and identify
# the domains of optimality in the resolution parameter for
# different partitions
data(karate, package = "igraphdata")
partitions <- get_partitions(karate, n_runs = 2500)
partitions <- CHAMP(karate, partitions, plottitle = "Weighted Karate Club")
partitions <- get_CHAMP_map(karate, partitions, plotlabel = "Weighted Karate Club")
}
\author{
Peter J. Mucha (\email{peter.j.mucha@dartmouth.edu}), Alex Craig, Rachel Matthew, Sydney Rosenbaum and Ava Scharfstein
}
