#ifndef IETEST_H
#define IETEST_H

#include <RcppArmadillo.h>
#include <RcppDist.h>

using namespace Rcpp;

arma::mat corrTrans(arma::vec meanVector, arma::vec nullVector, arma::mat sigma);

double normU(double V1, double V1_VAR, double V2, double V2_VAR, 
             int V2mult, double V1_V2_cov, double V1_0, double V2_0);

double tU(double V1, double V1_VAR, int V1_DF, double V2, double V2_VAR,
          int V2mult, double V1_V2_cov, double V1_0, double V2_0, double mcRep);

bool asq_one_bool(double alpha, double u1, double u2, 
                  long int numSquares, double upLim);

bool asq_ord_bool(double alpha, double u1, double u2, double u3, 
                  long int numSquares, double upLim);
// 
// // Functions called by ieTest wrapper function: 
// double sobelTest_one(const long double & mu1, const long double & sig1,
//               const long double & mu2, const long double & sig2, const long double & sig12,
//               const double & indL,
//               const long double & mu3, const long double & sig3,
//               const long double & sig13, const long double & sig23,
//               double mu1_0, double mu2_0, double mu3_0);
// 
// double sobelTest_two_seq(const long double & mu1, const long double & sig1,
//                          const long double & mu2, const long double & sig2,
//                          const long double & mu2b, const long double & sig2b,
//                          const long double & mu3, const long double & sig3,
//                          const long double & mu3b, const long double & sig3b,
//                          const long double & sig12, const long double & sig12b,
//                          const long double & sig13, const long double & sig13b,
//                          const long double & sig22b, const long double & sig23,
//                          const long double & sig23b,
//                          const long double & sig2b3, const long double & sig2b3b,
//                          const long double & sig33b,
//                          const int & indL,
//                          double mu1_0, double mu2_0, double mu2b_0,
//                          double mu3_0, double mu3b_0);
// 
// double sobelTest_two_sim(const long double & mu1, const long double & sig1, // alpha1
//                          const long double & mu2, const long double & sig2, // gamma1
//                          const long double & mu2b, const long double & sig2b, // psi1
//                          const long double & mu3, const long double & sig3, // alpha2
//                          const long double & mu4, const long double & sig4, // gamma2
//                          const long double & mu4b, const long double & sig4b, //psi2
//                          const long double & sig12, const long double & sig12b,
//                          const long double & sig13,
//                          const long double & sig14, const long double & sig14b,
//                          const long double & sig22b, const long double & sig23,
//                          const long double & sig24, const long double & sig24b,
//                          const long double & sig2b3,
//                          const long double & sig2b4, const long double & sig2b4b,
//                          const long double & sig34, const long double & sig34b,
//                          const long double & sig44b,
//                          const int & indL,
//                          double mu1_0, double mu2_0, double mu2b_0,
//                          double mu3_0, double mu4_0, double mu4b_0);
// 
// double maxp_one(Rcpp::Nullable<Rcpp::NumericVector> u1,
//          Rcpp::Nullable<Rcpp::NumericVector> u2,
//          Nullable<CharacterVector> V1Dist,
//          Rcpp::Nullable<Rcpp::NumericVector> V1, 
//          Rcpp::Nullable<Rcpp::NumericVector> V1_VAR,
//          Nullable<int> V1_DF,
//          Nullable<CharacterVector> V2Dist,
//          Rcpp::Nullable<Rcpp::NumericVector> V2, 
//          Rcpp::Nullable<Rcpp::NumericVector> V2_VAR,
//          Rcpp::Nullable<Rcpp::NumericVector> V2_DF,
//          double V2b, double V2b_VAR,
//          const int V2bmult,
//          double V1_V2_cov, double V1_V2b_cov,
//          double V2_V2b_cov,
//          double V1_0, double V2_0, double V2b_0);
//   
// double maxp_ord(Rcpp::Nullable<Rcpp::NumericVector> u1,
//          Rcpp::Nullable<Rcpp::NumericVector> u2,
//          Rcpp::Nullable<Rcpp::NumericVector> u3,
//          Nullable<CharacterVector> V1Dist,
//          Rcpp::Nullable<Rcpp::NumericVector> V1, 
//          Rcpp::Nullable<Rcpp::NumericVector> V1_VAR,
//          Nullable<int> V1_DF,
//          Nullable<CharacterVector> V2Dist,
//          Rcpp::Nullable<Rcpp::NumericVector> V2, 
//          Rcpp::Nullable<Rcpp::NumericVector> V2_VAR,
//          Rcpp::Nullable<Rcpp::NumericVector> V2_DF,
//          double V2b, double V2b_VAR,
//          const int V2bmult,
//          Nullable<CharacterVector> V3Dist,
//          Rcpp::Nullable<Rcpp::NumericVector> V3, 
//          Rcpp::Nullable<Rcpp::NumericVector> V3_VAR,
//          Rcpp::Nullable<Rcpp::NumericVector> V3_DF,
//          double V3b, double V3b_VAR,
//          double V1_V2_cov, double V1_V2b_cov,
//          double V1_V3_cov, double V1_V3b_cov,
//          double V2_V2b_cov,
//          double V2_V3_cov, double V2_V3b_cov,
//          double V2b_V3_cov, double V2b_V3b_cov,
//          double V3_V3b_cov,
//          double V1_0, double V2_0, double V2b_0,
//          double V3_0, double V3b_0,
//          double upLim, 
//          Rcpp::Nullable<Rcpp::NumericVector> alpha);
// 
// double ps_one(Rcpp::Nullable<Rcpp::NumericVector> u1,
//               Rcpp::Nullable<Rcpp::NumericVector> u2,
//               Nullable<CharacterVector> V1Dist,
//               Rcpp::Nullable<Rcpp::NumericVector> V1, 
//               Rcpp::Nullable<Rcpp::NumericVector> V1_VAR,
//               Nullable<int> V1_DF,
//               Nullable<CharacterVector> V2Dist,
//               Rcpp::Nullable<Rcpp::NumericVector> V2, 
//               Rcpp::Nullable<Rcpp::NumericVector> V2_VAR,
//               Rcpp::Nullable<Rcpp::NumericVector> V2_DF,
//               double V2b, double V2b_VAR,
//               const int V2bmult,
//               double V1_V2_cov, double V1_V2b_cov,
//               double V2_V2b_cov,
//               double V1_0, double V2_0, double V2b_0,
//               double upLim, 
//               Rcpp::Nullable<Rcpp::NumericVector> alpha);
//   
// double ps_ord(Rcpp::Nullable<Rcpp::NumericVector> u1,
//                 Rcpp::Nullable<Rcpp::NumericVector> u2,
//                 Rcpp::Nullable<Rcpp::NumericVector> u3,
//                 Nullable<CharacterVector> V1Dist,
//                 Rcpp::Nullable<Rcpp::NumericVector> V1, 
//                 Rcpp::Nullable<Rcpp::NumericVector> V1_VAR,
//                 Nullable<int> V1_DF,
//                 Nullable<CharacterVector> V2Dist,
//                 Rcpp::Nullable<Rcpp::NumericVector> V2, 
//                 Rcpp::Nullable<Rcpp::NumericVector> V2_VAR,
//                 Rcpp::Nullable<Rcpp::NumericVector> V2_DF,
//                 double V2b, double V2b_VAR,
//                 const int V2bmult,
//                 Nullable<CharacterVector> V3Dist,
//                 Rcpp::Nullable<Rcpp::NumericVector> V3, 
//                 Rcpp::Nullable<Rcpp::NumericVector> V3_VAR,
//                 Rcpp::Nullable<Rcpp::NumericVector> V3_DF,
//                 double V3b, double V3b_VAR,
//                 double V1_V2_cov, double V1_V2b_cov,
//                 double V1_V3_cov, double V1_V3b_cov,
//                 double V2_V2b_cov,
//                 double V2_V3_cov, double V2_V3b_cov,
//                 double V2b_V3_cov, double V2b_V3b_cov,
//                 double V3_V3b_cov,
//                 double V1_0, double V2_0, double V2b_0,
//                 double V3_0, double V3b_0,
//                 double upLim, 
//                 Rcpp::Nullable<Rcpp::NumericVector> alpha);
//     
// double asq_one(arma::vec alpha, Rcpp::Nullable<Rcpp::NumericVector> u1,
//             Rcpp::Nullable<Rcpp::NumericVector> u2,
//             Nullable<CharacterVector> V1Dist,
//             Rcpp::Nullable<Rcpp::NumericVector> V1, 
//             Rcpp::Nullable<Rcpp::NumericVector> V1_VAR,
//             Nullable<int> V1_DF,
//             Nullable<CharacterVector> V2Dist,
//             Rcpp::Nullable<Rcpp::NumericVector> V2, 
//             Rcpp::Nullable<Rcpp::NumericVector> V2_VAR,
//             Rcpp::Nullable<Rcpp::NumericVector> V2_DF,
//             double V2b, double V2b_VAR,
//             const int V2bmult,
//             double V1_V2_cov, double V1_V2b_cov,
//             double V2_V2b_cov,
//             double V1_0, double V2_0, double V2b_0,
//             long int numSquares, double upLim);
//       
// double asq_ord(arma::vec alpha, Rcpp::Nullable<Rcpp::NumericVector> u1,
//                Rcpp::Nullable<Rcpp::NumericVector> u2,
//                Rcpp::Nullable<Rcpp::NumericVector> u3,
//                Nullable<CharacterVector> V1Dist,
//                Rcpp::Nullable<Rcpp::NumericVector> V1, 
//                Rcpp::Nullable<Rcpp::NumericVector> V1_VAR,
//                Nullable<int> V1_DF,
//                Nullable<CharacterVector> V2Dist,
//                Rcpp::Nullable<Rcpp::NumericVector> V2, 
//                Rcpp::Nullable<Rcpp::NumericVector> V2_VAR,
//                Rcpp::Nullable<Rcpp::NumericVector> V2_DF,
//                double V2b, double V2b_VAR,
//                const int V2bmult,
//                Nullable<CharacterVector> V3Dist,
//                Rcpp::Nullable<Rcpp::NumericVector> V3, 
//                Rcpp::Nullable<Rcpp::NumericVector> V3_VAR,
//                Rcpp::Nullable<Rcpp::NumericVector> V3_DF,
//                double V3b, double V3b_VAR,
//                double V1_V2_cov, double V1_V2b_cov,
//                double V1_V3_cov, double V1_V3b_cov,
//                double V2_V2b_cov,
//                double V2_V3_cov, double V2_V3b_cov,
//                double V2b_V3_cov, double V2b_V3b_cov,
//                double V3_V3b_cov,
//                double V1_0, double V2_0, double V2b_0,
//                double V3_0, double V3b_0,
//                long int numSquares, double upLim);

#endif 
