% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/edf.R
\name{write_edf}
\alias{write_edf}
\alias{as_edf_channel}
\title{Write to 'EDF' format}
\usage{
as_edf_channel(
  x,
  channel_num,
  sample_rate,
  label = sprintf("Ch\%d", channel_num),
  physical_min = NA,
  physical_max = NA,
  is_annotation = NA,
  transducer_type = "",
  unit = "uV",
  filter = "",
  comment = ""
)

write_edf(
  channels,
  con,
  patient_id = "anomymous",
  recording_id = NULL,
  record_duration = NA,
  physical_min = NA,
  physical_max = NA,
  start_time = Sys.time()
)
}
\arguments{
\item{x}{channel signals or annotations; for signals, \code{x} is a
numeric vector; for annotations, \code{x} is a data frame with
\code{'timestamp'}, \code{'comments'}, and optionally \code{'duration'}
(case sensitive) columns}

\item{channel_num}{channel number, integer}

\item{sample_rate}{sampling frequency}

\item{label}{channel label, default is \code{'Ch'} followed by the channel
number for signal channels, or \code{"EDF Annotation"} for annotations}

\item{physical_min, physical_max}{range of the channel values when converting
from physical unit to digital; default is the range of \code{x}}

\item{is_annotation}{whether the channel is annotation}

\item{transducer_type}{transducer type}

\item{unit}{physical unit or dimension; default is \code{'uV'}}

\item{filter}{preliminary filters applied to the signals}

\item{comment}{additional comments (maximum 32 bytes)}

\item{channels}{list of channel data, each element should be generated
from \code{as_edf_channel}}

\item{con}{file path or binary connection}

\item{patient_id}{patient identifier; default is \code{'anomymous'}}

\item{recording_id}{recording identifier}

\item{record_duration}{duration of each recording chunk: 'EDF' format slices
the data into equal-length chunks and writes the data (interleave channels)
to file; this is the duration for each chunk, not the entire recording length}

\item{start_time}{start time of the recording; see \code{\link{as.POSIXct}}}
}
\value{
\code{as_edf_channel} returns a channel wrapper (with metadata);
\code{write_edf} writes to the connection and returns nothing
}
\description{
Currently supports continuous 'EDF+' format with annotations
}
\examples{


signal <- sin(seq(0, 10, 0.01))

channels <- list(

  # signal
  as_edf_channel(channel_num = 1, signal,
                 sample_rate = 375.5),

  as_edf_channel(channel_num = 2, signal,
                 sample_rate = 200),

  # annotation
  as_edf_channel(channel_num = 3, data.frame(
    timestamp = c(0, 1, 2),
    comments = c("Start", "half to go", "Finish!")
  ))

)

# write to file
path <- tempfile(fileext = ".edf")
write_edf(con = path, channels = channels)

edf <- read_edf(con = path, extract_path = tempdir())

annot <- edf$get_annotations()
annot


ch1 <- edf$get_channel(1)

# around 1e-5 due to digitization
range(ch1$value[seq_along(signal)] - signal)

ch2 <- edf$get_channel(2)
range(ch2$value[seq_along(signal)] - signal)


plot(ch1$time, ch1$value, type = "l",
     main = "Toy-example")
lines(ch2$time, ch2$value, col = "red")
abline(v = annot$timestamp, col = "gray", lty = 2)

edf$delete()
unlink(path)

}
