% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pkg.R
\name{image_harris}
\alias{image_harris}
\title{Find Corners using Harris Corner Detection}
\usage{
image_harris(
  x,
  k = 0.06,
  sigma_d = 1,
  sigma_i = 2.5,
  threshold = 130,
  gaussian = c("fast Gaussian", "precise Gaussian", "no Gaussian"),
  gradient = c("central differences", "Sobel operator"),
  strategy = c("all corners", "sort all corners", "N corners", "distributed N corners"),
  Nselect = 1L,
  measure = c("Harris", "Shi-Tomasi", "Harmonic Mean"),
  Nscales = 1L,
  precision = c("quadratic approximation", "quartic interpolation", "no subpixel"),
  cells = 10L,
  verbose = FALSE
)
}
\arguments{
\item{x}{an object of class magick-image or a greyscale matrix of image pixel values in the 0-255 range where values start at the top left corner.}

\item{k}{Harris' K parameter. Defaults to 0.06.}

\item{sigma_d}{Gaussian standard deviation for derivation. Defaults to 1.}

\item{sigma_i}{Gaussian standard deviation for integration. Defaults to 2.5.}

\item{threshold}{threshold for eliminating low values. Defaults to 130.}

\item{gaussian}{smoothing, either one of 'precise Gaussian', 'fast Gaussian' or 'no Gaussian'. Defaults to 'fast Gaussian'.}

\item{gradient}{calculation of gradient, either one of 'central differences' or 'Sobel operator'. Defaults to 'central differences'.}

\item{strategy}{strategy for selecting the output corners, either one of 'all corners', 'sort all corners', 'N corners', 'distributed N corners'. Defaults to 'all corners'.}

\item{Nselect}{number of output corners. Defaults to 1.}

\item{measure}{either one of 'Harris', 'Shi-Tomasi' or 'Harmonic Mean'. Defaults to 'Harris'.}

\item{Nscales}{number of scales for filtering out corners. Defaults to 1.}

\item{precision}{subpixel accuracy, either one of 'no subpixel', 'quadratic approximation', 'quartic interpolation'. Defaults to 'quadratic approximation'}

\item{cells}{regions for output corners (1x1, 2x2, ..., NxN). Defaults to 10.}

\item{verbose}{logical, indicating to show the trace of different substeps}
}
\value{
as list of the relevant points with the x/y locations as well as the strenght. Note y values start at the top left corner of the image.
}
\description{
An implementation of the Harris Corner Detection algorithm explained at \doi{10.5201/ipol.2018.229}.
}
\examples{
\dontshow{
mat <- system.file(package = "image.CornerDetectionHarris", "extdata", "building.rds")
mat <- readRDS(mat)
pts <- image_harris(mat)
}
\donttest{
library(magick)
path <- system.file(package = "image.CornerDetectionHarris", 
                    "extdata", "building.png")
x    <- image_read(path)
pts  <- image_harris(x)
pts

plt <- image_draw(x)
points(pts$x, pts$y, col = "red", pch = 20)
dev.off()
plt <- image_draw(x)
points(pts$x, pts$y, 
       col = "red", pch = 20, cex = 5 * pts$strength / max(pts$strength))
dev.off()

## Or pass on a greyscale matrix starting at top left
mat <- image_data(x, channels = "gray")
mat <- as.integer(mat, transpose = FALSE)
mat <- drop(mat)
pts <- image_harris(mat)
plt <- image_draw(x)
points(pts$x, pts$y, col = "red", pch = 20)
dev.off()
}
}
