% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imcExperiment.R
\name{imcExperiment}
\alias{imcExperiment}
\title{Initializes a imcExperiment and performs some rudimentary checks.
Many of the arguments CAN be NULL; determination of which is required
is done at run-time.  A imcExperiment must contain at least the
expressions and spatial/coordinate assays.}
\usage{
imcExperiment(
  coordinates = matrix(1, 3, 3),
  cellIntensity = matrix(1, 3, 3),
  neighborHood = matrix(1, 3, 3),
  network = data.frame(matrix(1, 3, 3)),
  distance = matrix(1, 3, 3),
  morphology = matrix(1, 3, 3),
  uniqueLabel = rep("A", 3),
  panel = as.character(seq_len(3)),
  ROIID = data.frame(ROIID = rep("A", 3)),
  ...
)
}
\arguments{
\item{coordinates}{matrix of spatial coordinates (x,y)}

\item{cellIntensity}{matrix of counts}

\item{neighborHood}{neighborhood results}

\item{network}{network assignments for each cell}

\item{distance}{distances for each cell, can be square}

\item{morphology}{morphology features for each cell, can be square}

\item{uniqueLabel}{character class each cell is assigned a uniqueLabel}

\item{panel}{antibody panel rownames set to rowData}

\item{ROIID}{character for ROI}

\item{...}{additional arguments}
}
\value{
imcExperiment container
}
\description{
Initializes a imcExperiment and performs some rudimentary checks.
Many of the arguments CAN be NULL; determination of which is required
is done at run-time.  A imcExperiment must contain at least the
expressions and spatial/coordinate assays.
}
\examples{
x<-imcExperiment(cellIntensity=matrix(1,nrow=10,ncol=10),
coordinates=matrix(1,nrow=10,ncol=2),
neighborHood=matrix(1,nrow=10,ncol=10),
network=data.frame(matrix(1,nrow=10,ncol=10)),
distance=matrix(1,nrow=10,ncol=10),
morphology=matrix(1,nrow=10,ncol=10),
uniqueLabel=paste0("A",seq_len(10)),
panel=letters[1:10],
ROIID=data.frame(ROIID=rep("A",10)))

}
