% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stop_fun.R
\name{stop_ds_difference}
\alias{stop_ds_difference}
\title{Compare differences between two data sets}
\usage{
stop_ds_difference(
  ds,
  ds_old,
  info_list,
  stop_args = list(eps = 1e-06, p = 1, sum_diffs = TRUE, na_rm = TRUE),
  res_stop_fun = NULL
)
}
\arguments{
\item{ds}{A numeric data set}

\item{ds_old}{A numeric data set}

\item{info_list}{\code{info_list} used inside of \code{\link[=impute_iterative]{impute_iterative()}}. Only the
list element \code{nr_iterations} is used/needed.}

\item{stop_args}{A list with following named components (missing elements
will be replaced by default ones):
\itemize{
\item \code{eps} Threshold value for the difference (default = 1e-6).
\item \code{p} Exponent used for the calculation of differences similar to
Minkowski distance. For \code{p = 1} (default) the absolute differences are
used. For \code{p = 2} The quadratic differences are summed and the square
root of this sum is compared with \code{stop_eps}.
\item \code{sum_diffs} Should differences be summed (default) or averaged
(\code{sum_diffs = FALSE})?
\item \code{na_rm} Should \code{NA}-values be removed (default) when calculating the
sum/average? If \code{na_rm = FALSE} and there are \code{NA}s, the function
returns \code{FALSE}.
}}

\item{res_stop_fun}{Only needed to be a valid stop function. Internally,
this argument is ignored at the moment.}
}
\value{
\code{list(stop_iter = FALSE)}, if the difference is too big. Otherwise
\code{ds} with number of iterations (\code{nr_iterations}) as attribute.
}
\description{
This function is intended to be used as \code{stop_fun} inside of
\code{\link[=impute_iterative]{impute_iterative()}}. It compares the difference of two (numeric) data sets
and return \code{ds}, if difference is small enough (less than \code{stop_args$eps}).
}
\examples{
set.seed(123)
ds1 <- data.frame(X = rnorm(10), Y = rnorm(10))
ds2 <- data.frame(X = rnorm(10), Y = rnorm(10))
all.equal(
  stop_ds_difference(ds1, ds1, list(nr_iterations = 3)),
  structure(ds1, nr_iterations = 3)
)
stop_ds_difference(ds1, ds2, list(nr_iterations = 42))
}
