% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correct_middle_REE.r
\name{correct_middle}
\alias{correct_middle}
\title{Corrects for the model deviations of Yb, Lu and Y}
\usage{
correct_middle(
  dat,
  Nd_correction_fact = 1/0.989,
  Sm_correction_fact = 1/1.022,
  Gd_correction_fact = 1/1.033,
  Tb_correction_fact = 1/1.05,
  Dy_correction_fact = 1/1.032,
  Pr_correction_fact = 1/0.918
)
}
\arguments{
\item{dat}{A dataframe}

\item{Nd_correction_fact}{a number: correction factor for underestimated Nd 1/0.0.989}

\item{Sm_correction_fact}{a number: correction factor for overestimated Sm 1/1.022}

\item{Gd_correction_fact}{a number: correction factor for overestimated Gd 1/1.033}

\item{Tb_correction_fact}{a number: correction factor for overestimated Tb 1/1.050}

\item{Dy_correction_fact}{a number: correction factor for overestimated Dy 1/1.032}

\item{Pr_correction_fact}{a number: correction factor for overestimated Pr 1/0.918}
}
\value{
a data frame
}
\description{
Calculated value of Yb, Lu and Y slightly deviates from the linear regression. This function apply a correction to compensates those deviations. This function is wrapped inside model_REE()
}
