% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Model_Wrappers.r
\name{modelZhong}
\alias{modelZhong}
\title{Model REE contents using the method of \href{https://link.springer.com/article/10.1007/s00710-019-00682-y}{Zhong et al. (2019)}}
\usage{
modelZhong(
  dat,
  exclude = c("La", "Pr", "Ce", "Eu", "Y"),
  Calibrate = F,
  chondrite = PalmeOneill2014CI,
  prefix = NULL,
  suffix = NULL
)
}
\arguments{
\item{dat}{A data frame with REE data in ppm}

\item{exclude}{a string: vector including elements that should be omitted from modelling. La, Ce and Eu are the default. Ce and Eu should be always included}

\item{Calibrate}{Logical (T or F). If True, the model is calibrated using the correction factors. By default it is the reciprocal of the median REE from the work of Carrasco-Godoy and Campbell is used.}

\item{chondrite}{an option from: PalmeOneill2014CI, Oneill2014Mantle, McDonough1995CI}

\item{prefix}{A prefix in your columns e.g. ICP_La}

\item{suffix}{A suffix in your columns e.g. La_ppm}
}
\value{
a dataframe
}
\description{
This function apply the logarithmic regression using the method of \href{https://link.springer.com/article/10.1007/s00710-019-00682-y}{Zhong et al. (2019)}. This method considers the relationship between the logarithm of the REE atomic number vs their chondrite normalized values. For more information refer to the \href{https://link.springer.com/article/10.1007/s00710-019-00682-y}{Zhong et al. (2019)} and \href{https://link.springer.com/article/10.1007/s00410-023-02025-9}{Carrasco-Godoy and Campbell (2023)} for a discussion of its limitations to calculate La or Ce*.
}
\examples{
Ballard_et_al_Zircon \%>\%  modelZhong(prefix = 'Zr', suffix = 'ppm')
}
\seealso{
Other model REE: 
\code{\link{modelChondrite_Onuma}()},
\code{\link{modelChondrite_lattice}()},
\code{\link{model_REE}()}
}
\concept{model REE}
