% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{ebola_cases_df}
\alias{ebola_cases_df}
\title{Time Series Counts of Ebola Cases}
\format{
A data frame with 192 observations and 3 variables:
\describe{
  \item{time}{Integer indicating the number of days since the beginning of observation}
  \item{clin_signs}{Integer indicating the number of new individuals with clinical signs of Ebola}
  \item{removals}{Integer indicating the number of new removals (e.g., deaths or recoveries)}
}
}
\source{
Data taken from the SimBIID package version 0.2.2
}
\usage{
data(ebola_cases_df)
}
\description{
This dataset, ebola_cases_df, is a data frame containing daily time series counts of new individuals
exhibiting clinical signs of Ebola virus disease, as well as the number of daily removals (e.g., deaths or recoveries),
during the 1995 Ebola epidemic in the Democratic Republic of Congo (DRC).
}
\details{
The dataset name has been kept as 'ebola_cases_df' to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
infectiousR package and assists users in identifying its specific characteristics.
The suffix 'df' indicates that the dataset is a data frame. The original content has not been modified
in any way.
}
