% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DroppingInterval.R
\name{intervalpdf}
\alias{intervalpdf}
\title{Probability density function of an observed interval distribution}
\usage{
intervalpdf(
  data = seq(0, 1000),
  mu = 200,
  sigma = 40,
  p = 0.3,
  N = 5L,
  fun = "gamma",
  trunc = c(0, Inf),
  fpp = 0,
  sigma.within = NA
)
}
\arguments{
\item{data}{A list of intervals for which to calculate the probability density}

\item{mu}{The mean of the true interval distribution}

\item{sigma}{The standard deviation of the true interval distribution}

\item{p}{The probability that an arrival that marks the start or end of an interval is not observed}

\item{N}{The maximum number of consecutive missed arrivals to take into consideration}

\item{fun}{assumed distribution family of the true interval distribution, one of
"\code{normal}" or "\code{gamma}", corresponding
to the \link[stats]{Normal} and \link[stats]{GammaDist} distributions.}

\item{trunc}{Use a truncated probability density function with range \code{trunc}}

\item{fpp}{Baseline proportion of intervals distributed as a random poisson process with mean arrival rate \code{mu}}

\item{sigma.within}{within-subject standard deviation, only available when \code{fun} is "normal"}
}
\value{
This function returns a list of points describing the interval distribution
}
\description{
Observed intervals are assumed to be sampled through observation of continuous
distinct arrivals in time. Two subsequently observed arrivals mark the start and end
of an interval. The probability that an arrival is not observed can be nonzero, leading to
observed intervals at integer multiples of the true interval.
}
\details{
\subsection{General}{
intervals x are assumed to follow a standard distribution (either a normal
or gamma distribution) with probability density function \eqn{\phi(x|\mu,\sigma)}
with \eqn{\mu} the mean arrival interval and \eqn{\sigma} its associated standard deviation.
The probability density function \eqn{\phi_{obs}} of observed arrival intervals
in a scenario where the probability to not observe an arrival is nonzero,
will be a superposition of several standard distributions, at multiples of the fundamental mean
arrival interval. Standard distribution \eqn{i} will correspond to those intervals where \eqn{i} arrivals have been
missed consecutively. If \eqn{p} equals this probability of not observing an arrival, then the
probability \eqn{P(i)} to miss \eqn{i} consecutive arrivals equals
\deqn{P(i)=p^i-p^{i+1}}{P(i)=p^i-p^{i+1}}
The width of standard distribution i will be broadened relative to the fundamental, according to
standard uncertainty propagation in the case of addition. Both in the case
of normal and gamma-distributed intervals (see next subsections) we may write for the observed
probability density function, \eqn{\phi_{obs}}:
\deqn{\phi_{obs}(x | \mu, \sigma, p)=\sum_{i=1}^\infty \phi_{obs}(x,i | \mu,\sigma,p)}{\phi_{obs}(x | \mu, \sigma, p)=\sum_{i=1}^\infty \phi_{obs}(x,i | \mu,\sigma,p)}
with
\deqn{\phi_{obs}(x,i | \mu, \sigma, p)= P(i-1) \phi(x | i \mu,\sqrt i \sigma)}{\phi_{obs}(x,i | \mu, \sigma, p)= P(i-1) \phi(x | i \mu,\sqrt i \sigma)}
In practice, this probability density function is well approximate when the infinite sum is capped at a finite integer N.
Be default the sum is ran up to N=5.

}
\subsection{Gamma-distributed intervals}{
By default intervals x are assumed to follow a Gamma (\link[stats]{GammaDist}) distribution \eqn{Gamma(\mu,\sigma)}~\code{\link[stats]{dgamma}(shape=}\eqn{\mu^2/\sigma^2}\code{, scale=}\eqn{\sigma^2/\mu)}
with a probability density function \eqn{\phi(x)}:
\deqn{\phi(x|\mu,\sigma)~Gamma(\mu,\sigma)}{\phi(x|\mu,\sigma)~Gamma(\mu,\sigma)}
which has a mean \eqn{\mu} and standard deviation \eqn{\sigma}.
}
\subsection{Normal-distributed intervals}{
intervals x may also be assumed to follow a \link[stats]{Normal} distribution \eqn{N(\mu,\sigma)}~\code{\link[stats]{dnorm}(mean=}\eqn{\mu}\code{,sd=}\eqn{\sigma)},
with a probability density function \eqn{\phi(x)}:
\deqn{\phi(x|\mu,\sigma)~N(\mu,\sigma)}{\phi(x|\mu,\sigma)~N(\mu,\sigma)}
which also has a mean \eqn{\mu} and standard deviation \eqn{\sigma}. Because intervals
are by definition non-negative, the Normal distribution is always truncated at zero.
In the limit that \eqn{\mu>\sigma} the gamma distribution tends to the normal distribution.
}
\subsection{Within and between-subject variation}{
To account for witin-subject and between-subject differences in mean interval length we define
\eqn{\sigma_w} as within-subject standard deviation in interval length,
and \eqn{\sigma_b} as between-subject standard deviation in interval length,
with \eqn{\sigma^2 = \sigma^2_b + \sigma^2_w}.
In the normal limit (\eqn{\mu>\sigma}) the population pdf will be a convolution between \eqn{\phi(x|\mu,\sigma_b)}
and \eqn{\phi(x|\mu,\sigma_w)} equal to:
\deqn{\phi_{obs}(x | \mu, \sigma,\sigma_w,p)=\sum_{i=1}^\infty P(i-1) \phi(x | i \mu,\sqrt i \sigma)}{\phi_{obs}(x | \mu,\sigma,p)=\sum_{i=1}^\infty P(i-1) \phi(x | i \mu,\sqrt{i {\sigma_w}^2 + \sigma^2})}
}
}
\examples{
# a low probability of not observing an arrival
# results in an observed PDF with primarily
# a single peak, with a mean and standard
# deviation almost identical to the true interval
# distribution:
plot(intervalpdf(mu=200,sigma=40,p=0.01),type='l',col='red')

# a higher probability to miss an arrival
# results in an observed PDF with multiple
# peaks at integer multiples of the mean of the true
# interval distribution
plot(intervalpdf(mu=200,sigma=40,p=0.4),type='l',col='red')
}
