% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Interplot_mi.R
\name{interplot.lmmi}
\alias{interplot.lmmi}
\title{Plot Conditional Coefficients in (Generalized) Linear Models with Imputed Data and Interaction Terms}
\source{
Benjamini, Yoav, and Yosef Hochberg. 1995. "Controlling the False
Discovery Rate: A Practical and Powerful Approach to Multiple Testing".
Journal of the Royal Statistical Society, Series B 57(1): 289--300.

Brambor, Thomas, William Roberts Clark, and Matt Golder.
"Understanding interaction models: Improving empirical analyses". Political
Analysis 14.1 (2006): 63-82.

Esarey, Justin, and Jane Lawrence Sumner. 2015. "Marginal Effects in
Interaction Models: Determining and Controlling the False Positive Rate".
URL: \url{http://jee3.web.rice.edu/interaction-overconfidence.pdf}.
}
\usage{
\method{interplot}{lmmi}(
  m,
  var1,
  var2,
  plot = TRUE,
  steps = NULL,
  ci = 0.95,
  adjCI = FALSE,
  hist = FALSE,
  var2_dt = NA,
  predPro = FALSE,
  var2_vals = NULL,
  point = FALSE,
  sims = 5000,
  xmin = NA,
  xmax = NA,
  ercolor = NA,
  esize = 0.5,
  ralpha = 0.5,
  rfill = "grey70",
  stats_cp = "none",
  txt_caption = NULL,
  facet_labs = NULL,
  ...
)
}
\arguments{
\item{m}{A model object including an interaction term, or, alternately, a data frame recording conditional coefficients.}

\item{var1}{The name (as a string) of the variable of interest in the interaction term; its conditional coefficient estimates will be plotted.}

\item{var2}{The name (as a string) of the other variable in the interaction term.}

\item{plot}{A logical value indicating whether the output is a plot or a dataframe including the conditional coefficient estimates of var1, their upper and lower bounds, and the corresponding values of var2.}

\item{steps}{Desired length of the sequence. A non-negative number, which for seq and seq.int will be rounded up if fractional. The default is 100 or the unique categories in the \code{var2} (when it is less than 100. Also see \code{\link{unique}}).}

\item{ci}{A numeric value defining the confidence intervals. The default value is 95\% (0.95).}

\item{adjCI}{A logical value indication if applying the adjustment of confidence intervals to control the false discovery rate following the Esarey and Sumner (2017) procedure. (See also Benjamini and Hochberg 1995.) The default is FALSE; the plot presents the confidence intervals suggested by Brambor, Clark, and Golder (2006).}

\item{hist}{A logical value indicating if there is a histogram of `var2` added at the bottom of the conditional effect plot.}

\item{var2_dt}{A numerical value indicating the frequency distribution of `var2`. It is only used when `hist == TRUE`. When the object is a model, the default is the distribution of `var2` of the model.}

\item{predPro}{A logical value with default of `FALSE`. When the `m` is an object of class `glm` and the argument is set to `TRUE`, the function will plot predicted probabilities at the values given by `var2_vals`.}

\item{var2_vals}{A numerical value indicating the values the predicted probabilities are estimated, when `predPro` is `TRUE`.}

\item{point}{A logical value determining the format of plot. By default, the function produces a line plot when var2 takes on ten or more distinct values and a point (dot-and-whisker) plot otherwise; option TRUE forces a point plot.}

\item{sims}{Number of independent simulation draws used to calculate upper and lower bounds of coefficient estimates: lower values run faster; higher values produce smoother curves.}

\item{xmin}{A numerical value indicating the minimum value shown of x shown in the graph. Rarely used.}

\item{xmax}{A numerical value indicating the maximum value shown of x shown in the graph. Rarely used.}

\item{ercolor}{A character value indicating the outline color of the whisker or ribbon.}

\item{esize}{A numerical value indicating the size of the whisker or ribbon.}

\item{ralpha}{A numerical value indicating the transparency of the ribbon.}

\item{rfill}{A character value indicating the filling color of the ribbon.}

\item{stats_cp}{A character value indicating what statistics to present as the plot note. Three options are available: "none", "ci", and "ks". The default is "none". See the Details for more information.}

\item{txt_caption}{A character string to add a note for the plot, a value will sending to \code{ggplot2::labs(caption = txt_caption))}.}

\item{facet_labs}{An optional character vector of facet labels to be used when plotting an interaction with a factor variable.}

\item{...}{Other ggplot aesthetics arguments for points in the dot-whisker plot or lines in the line-ribbon plots. Not currently used.}
}
\value{
The function returns a \code{ggplot} object.
}
\description{
\code{interplot.mi} is a method to calculate conditional coefficient estimates from the results of (generalized) linear regression models with interaction terms and multiply imputed data.
}
\details{
\code{interplot.lmmi} and \code{interplot.glmmi} are S3 methods from the \code{interplot}. This function can work on interactions from results in the class of \code{list} generated by \code{mitools}.

Because the output function is based on \code{\link[ggplot2]{ggplot}}, any additional arguments and layers supported by \code{ggplot2} can be added with the \code{+}. 

\code{interplot} visualizes the conditional effect based on simulated marginal effects. The simulation provides a probabilistic distribution of moderation effect of the conditioning variable (\code{var2}) at every preset values (including the minimum and maximum values) of the conditioned variable (\code{var1}), denoted as Emin and Emax. This output allows the function to further examine the conditional effect statistically in two ways. One is to examine if the distribution of \eqn{Emax - Emin} covers zero. The other is to directly compare Emin and Emax through statistical tools for distributional comparisons. Users can choose either method by setting the argument \code{stats_cp} to "ci" or "ks".
\itemize{
  \item "ci" provides the confidence interval of the difference of \eqn{Emax - Emin}. An interval including 0 suggests no statistical difference before and after the conditional effect is applied, and vise versa.
  \item "ks" presents the result of a two-sample Kolmogorov-Smirnov test of the simulated distributions of Emin and Emax. The output includes a D statistics and a p-value of the null hypothesis that the two distributions come from the same distribution at the 0.05 level.
}


See an illustration in the package vignette.
}
\examples{

library(interplot)
library(mitools)

data(smi)
model1 <- with(smi, glm(drinkreg ~ wave * sex, family = binomial()))

interplot(model1, var1 = "sex", var2 = "wave")

}
