% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meanCI_sub.R
\name{meanCI.data.frame}
\alias{meanCI.data.frame}
\alias{meanCI_sub}
\title{Calculate confidence intervals of mean or difference between means in a data.frame}
\usage{
\method{meanCI}{data.frame}(x, ...)

meanCI_sub(data = data, x, y, group, paired = FALSE, idx = NULL, ...)
}
\arguments{
\item{x}{Name of a categorical or numeric column. If !missing(y), name of continuous variable}

\item{...}{Further arguments to be passed to meanCI}

\item{data}{A data.frame}

\item{y}{Name of a numeric column}

\item{group}{Name of categorical column}

\item{paired}{logical}

\item{idx}{A vector containing factors or strings in the x columns. These must be quoted (ie. surrounded by quotation marks).
The first element will be the control group, so all differences will be computed for every other group and this first group.}
}
\value{
An object of class "meanCI" which is a list containing at least the following components:
\describe{
  \item{data}{A tibble containing raw data or a list of numeric vector}
  \item{result}{A data.frame consists of summary statistics}
  \item{call}{the matched call}
  \item{attr(*,"measure")}{character. One of c("mean","unpaired","paired")}
}
}
\description{
Calculate confidence intervals of mean or difference between means in a data.frame
}
\section{Methods (by generic)}{
\itemize{
\item \code{meanCI}: S3 method for data.frame
}}

\examples{
meanCI(acs,age)
meanCI(acs,sex,age)
meanCI(acs,Dx,age)
acs \%>\% select(age) \%>\% meanCI()
acs \%>\% select(sex,age) \%>\% meanCI()
meanCI(iris,Species,Sepal.Length)
meanCI(iris,Sepal.Width,Sepal.Length,paired=TRUE)
meanCI(iris,Sepal.Length,Sepal.Width)
iris \%>\% select(starts_with("Petal")) \%>\% meanCI(paired=TRUE)
iris \%>\% meanCI(paired=TRUE)
meanCI(acs,sex,age,Dx,mu=10)
acs \%>\% select(sex,TC,TG,HDLC) \%>\% meanCI(group=sex)
acs \%>\% select(sex,TC,TG,HDLC) \%>\% meanCI(sex)
iris \%>\% select(Species,starts_with("Sepal")) \%>\% meanCI(Species)
iris \%>\% select(Species,starts_with("Sepal")) \%>\% meanCI(group=Species)
}
