#' @name OECD21ed_CHN_1995to2018
#' @docType data
#' @title Input-output tables of the OECD 2021 edition for China, 1995--2018, 45 sectors
#' @description The national input-output tables of China for the period from 1995 to 2018, covering 45 sectors.
#'     Data are calculated in current prices.
#'     Values are denoted in millions of US dollars (USD).
#' @usage data(OECD21ed_CHN_1995to2018)
#' @format A list containing 24 data frames, each with 50 rows and 56 columns.
#' @source \href{https://www.oecd.org/sti/ind/input-outputtables.htm}{Input-Output Tables (IOTs) 2021 ed. - OECD}
"OECD21ed_CHN_1995to2018"


#' @name OECD21ed_JPN_1995to2018
#' @docType data
#' @title Input-output tables of the OECD 2021 edition for Japan, 1995--2018, 45 sectors
#' @description The national input-output tables of Japan for the period from 1995 to 2018, covering 45 sectors.
#'     Data are calculated in current prices.
#'     Values are denoted in millions of US dollars (USD).
#' @usage data(OECD21ed_JPN_1995to2018)
#' @format A list containing 24 data frames, each with 50 rows and 56 columns.
#' @source \href{https://www.oecd.org/sti/ind/input-outputtables.htm}{Input-Output Tables (IOTs) 2021 ed. - OECD}
"OECD21ed_JPN_1995to2018"
