% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter.R
\name{filter_top}
\alias{filter_top}
\title{Filter top NDVI}
\usage{
filter_top(DT, probs = 0.925, id = "id")
}
\arguments{
\item{DT}{data.table of NDVI time series}

\item{probs}{quantile probability to determine top. default is 0.925.}

\item{id}{id column. default is 'id'. See details.}
}
\value{
filtered data.table with appended 'top' column of each id's top (quantile) NDVI value.
}
\description{
Using upper quantile (default = 0.925) of multi-year MODIS data, determine the top NDVI for each id.
}
\details{
The id argument is used to split between sampling units. This may be a point id, polygon id, pixel id, etc. depending on your analysis.
}
\examples{
# Load data.table
library(data.table)

# Read example data
ndvi <- fread(system.file("extdata", "sampled-ndvi-MODIS-MOD13Q1.csv", package = "irg"))

filter_qa(ndvi, ndvi = 'NDVI', qa = 'SummaryQA', good = c(0, 1))
filter_winter(ndvi, probs = 0.025, limits = c(60L, 300L), doy = 'DayOfYear', id = 'id')
filter_roll(ndvi, window = 3L, id = 'id')
filter_top(ndvi, probs = 0.925, id = 'id')
}
\seealso{
Other filter: 
\code{\link{filter_ndvi}()},
\code{\link{filter_qa}()},
\code{\link{filter_roll}()},
\code{\link{filter_winter}()}
}
\concept{filter}
