% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/ternary_box.R
\docType{methods}
\name{ternary_box}
\alias{ternary_box}
\title{Draw a Box around a Ternary Plot}
\usage{
ternary_box(lty = "solid", ...)
}
\arguments{
\item{lty}{A \code{\link{character}} string or \code{\link{numeric}} value specifying the line
type of the box.}

\item{...}{Other \link[graphics:par]{graphical parameters} may also be passed as
arguments to this function, particularly, \code{col} or \code{lwd}.}
}
\value{
\code{ternary_box()} is called it for its side-effects.
}
\description{
Draw a Box around a Ternary Plot
}
\examples{
## Add axis
ternary_plot(NULL, axes = FALSE)
ternary_axis(side = 1, col = "red")
ternary_axis(side = 2, col = "blue")
ternary_axis(side = 3, col = "green")

## Add box and grid
ternary_plot(NULL, axes = FALSE)
ternary_box(lty = "dashed", col = "red")
ternary_grid(lty.primary = "dotted")
}
\seealso{
Other graphical elements: 
\code{\link{ternary_axis}()},
\code{\link{ternary_grid}()},
\code{\link{ternary_pairs}()},
\code{\link{ternary_plot}()},
\code{\link{ternary_title}()}
}
\author{
N. Frerebeau
}
\concept{graphical elements}
