% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dim_reduce.R
\name{dim_reduce}
\alias{dim_reduce}
\title{Remove environmental variables that have high correlation with others.}
\usage{
dim_reduce(
  img_stack = NULL,
  threshold = 0.5,
  preferred_vars = NULL,
  samples = NULL
)
}
\arguments{
\item{img_stack}{(\code{stars} or \code{RasterStack})
The image stack to work on.}

\item{threshold}{(\code{numeric}) The threshold number of Pearson
correlation that indicates two variables are strongly correlated.
The default is 0.5.}

\item{preferred_vars}{(\code{vector} of \code{character}) The preferred
variables \bold{in order} in dimension reduction. The preferred variables
will move to the beginning before the reduction. So make sure they are
placed in order. Furthermore, setting preferred_vars does not guarantee
they can survive. For example, one preferred variable that is placed later
has strong correlation with former preferred variable.}

\item{samples}{(\code{\link[sf:sf]{sf}} or \code{sp}) The samples to reduce
dimension.
If not \code{NULL}, it can take \code{\link[sf:sf]{sf}}, \code{\link[sf:sf]{sfc}},
\code{SpatialPointsDataFrame}, \code{SpatialPoints}, etc.
If \code{NULL}, the whole raster stack would be used.
The default is \code{NULL}.}
}
\value{
(\code{ReducedImageStack}) A list of
\itemize{
\item{threshold (\code{numeric}) The threshold set in function inputs}
\item{img_reduced (\code{stars}) The image stack after dimension reduction}
\item{cors_original (\code{\link{data.frame}}) A table of Pearson
correlations between all variables.}
\item{cors_reduced (\code{\link{data.frame}}) A table of Pearson
correlations between variables after dimension reduction.}}
}
\description{
Select environmental variables that have pairwise Pearson
correlation lower than a user-defined threshold.
NOTE that it only works on numeric variables, does not work on
categorical variables.
}
\examples{
\donttest{
library(sf)
library(itsdm)
library(stars)
library(dplyr)
env_vars <- system.file(
  'extdata/bioclim_tanzania_10min.tif',
  package = 'itsdm') \%>\% read_stars()
img_reduced <- dim_reduce(env_vars, threshold = 0.7,
  preferred_vars = c('bio1', 'bio12'))
}

}
