% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/relation.R
\name{relation-detect-pairwise}
\alias{relation-detect-pairwise}
\alias{iv_pairwise_overlaps}
\alias{iv_pairwise_precedes}
\alias{iv_pairwise_follows}
\title{Pairwise detect a relationship between two ivs}
\usage{
iv_pairwise_overlaps(x, y, ..., type = "any")

iv_pairwise_precedes(x, y)

iv_pairwise_follows(x, y)
}
\arguments{
\item{x, y}{\verb{[iv]}

A pair of interval vectors.

These will be recycled against each other and cast to the same type.}

\item{...}{These dots are for future extensions and must be empty.}

\item{type}{\verb{[character(1)]}

The type of relationship to find. One of:
\itemize{
\item \code{"any"}: Finds any overlap whatsoever between an interval in \code{needles}
and an interval in \code{haystack}.
\item \code{"within"}: Finds when an interval in \code{needles} is completely within
(or equal to) an interval in \code{haystack}.
\item \code{"contains"}: Finds when an interval in \code{needles} completely contains
(or equals) an interval in \code{haystack}.
\item \code{"equals"}: Finds when an interval in \code{needles} is exactly equal to
an interval in \code{haystack}.
\item \code{"starts"}: Finds when the start of an interval in \code{needles} matches the
start of an interval in \code{haystack}.
\item \code{"ends"}: Finds when the end of an interval in \code{needles} matches the end
of an interval in \code{haystack}.
}}
}
\value{
A logical vector the same size as the common size of \code{x} and \code{y}.
}
\description{
This family of functions detects different types of relationships between
two ivs \emph{pairwise}, where pairwise means that the i-th interval of
\code{x} is compared against the i-th interval of \code{y}. This is in contrast to
\code{\link[=iv_overlaps]{iv_overlaps()}}, which works more like \link[base:match]{base::\%in\%}.
\itemize{
\item \code{iv_pairwise_overlaps()} detects a specific \code{type} of overlap
between the i-th interval of \code{x} and the i-th interval of \code{y}.
\item \code{iv_pairwise_precedes()} detects if the i-th interval of \code{x}
precedes (i.e. comes before) the i-th interval of \code{y}.
\item \code{iv_pairwise_follows()} detects if the i-th interval of \code{x}
follows (i.e. comes after) the i-th interval of \code{y}.
}

These functions return a logical vector the same size as the common size of
\code{x} and \code{y}.
}
\examples{
library(vctrs)

x <- iv_pairs(
  as.Date(c("2019-01-05", "2019-01-10")),
  as.Date(c("2019-01-07", "2019-01-15")),
  as.Date(c("2019-01-20", "2019-01-31"))
)

y <- iv_pairs(
  as.Date(c("2019-01-01", "2019-01-03")),
  as.Date(c("2019-01-07", "2019-01-09")),
  as.Date(c("2019-01-18", "2019-01-21"))
)

x
y

# Does the i-th interval of `x` overlap the i-th interval of `y`?
iv_pairwise_overlaps(x, y)

# Does the i-th interval of `x` contain the i-th interval of `y`?
iv_pairwise_overlaps(x, y, type = "contains")

# Does the i-th interval of `x` follow the i-th interval of `y`?
iv_pairwise_follows(x, y)

a <- iv_pairs(c(1, 2), c(NA, NA), c(NA, NA))
b <- iv_pairs(c(NA, NA), c(3, 4), c(NA, NA))

# Missing intervals always propagate
iv_pairwise_overlaps(a, b)
}
\seealso{
\link[=relation-locate]{Locating relationships}

\link[=relation-detect]{Detecting relationships}

\link[=allen-relation-locate]{Locating relations from Allen's Interval Algebra}
}
