% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/JackCombination.R
\name{JackCombination}
\alias{JackCombination}
\title{Symmetric polynomial in terms of Jack polynomials}
\usage{
JackCombination(qspray, alpha, which = "J", check = TRUE)
}
\arguments{
\item{qspray}{a \code{qspray} object or a \code{symbolicQspray} object
defining a symmetric polynomial}

\item{alpha}{Jack parameter, must be coercible to a \code{bigq} number}

\item{which}{which Jack polynomials, \code{"J"}, \code{"P"}, \code{"Q"} or
\code{"C"}}

\item{check}{Boolean, whether to check the symmetry of \code{qspray}}
}
\value{
A list defining the combination. Each element of this list is a
  list with two elements: \code{coeff}, which is a \code{bigq} number if
  \code{qspray} is a \code{qspray} polynomial or a \code{ratioOfQsprays} if
  \code{qspray} is a \code{symbolicQspray} polynomial, and the second
  element of the list is \code{lambda}, an integer partition; then this list
  corresponds to the term \code{coeff * JackPol(n, lambda, alpha, which)},
  where \code{n} is the number of variables in the symmetric polynomial
  \code{qspray}.
}
\description{
Expression of a symmetric polynomial as a linear combination
  of Jack polynomials.
}
