% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Dixon.R
\name{Dixon}
\alias{Dixon}
\alias{sm}
\alias{cm}
\title{Dixon elliptic functions}
\usage{
sm(z)

cm(z)
}
\arguments{
\item{z}{a real or complex number}
}
\value{
A complex number.
}
\description{
The Dixon elliptic functions.
}
\examples{
# cubic Fermat curve x^3+y^3=1
pi3 <- beta(1/3, 1/3)
epsilon <- 0.7
t_ <- seq(-pi3/3 + epsilon, 2*pi3/3 - epsilon, length.out = 100)
pts <- t(vapply(t_, function(t) {
  c(Re(cm(t)), Re(sm(t)))
}, FUN.VALUE = numeric(2L)))
plot(pts, type = "l", asp = 1)
}
