% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_jags.R
\name{tar_jags_run}
\alias{tar_jags_run}
\title{Run a JAGS model and return the whole output object.}
\usage{
tar_jags_run(
  jags_lines,
  parameters.to.save,
  data,
  inits,
  n.cluster,
  n.chains,
  n.iter,
  n.burnin,
  n.thin,
  jags.module,
  RNGname,
  jags.seed,
  stdout,
  stderr,
  progress.bar,
  refresh
)
}
\arguments{
\item{jags_lines}{Character vector of lines from a JAGS model file.}

\item{parameters.to.save}{Model parameters to save, passed to
\code{R2jags::jags()} or \code{R2jags::jags.parallel()}.
See the argument documentation of the
\code{R2jags::jags()} and \code{R2jags::jags.parallel()} help files for details.}

\item{inits}{Initial values of model parameters, passed to
\code{R2jags::jags()} or \code{R2jags::jags.parallel()}.
See the argument documentation of the
\code{R2jags::jags()} and \code{R2jags::jags.parallel()} help files for details.}

\item{n.cluster}{Number of parallel processes, passed to
\code{R2jags::jags()} or \code{R2jags::jags.parallel()}.
See the argument documentation of the
\code{R2jags::jags()} and \code{R2jags::jags.parallel()} help files for details.}

\item{n.chains}{Number of MCMC chains, passed to
\code{R2jags::jags()} or \code{R2jags::jags.parallel()}.
See the argument documentation of the
\code{R2jags::jags()} and \code{R2jags::jags.parallel()} help files for details.}

\item{n.iter}{Number if iterations (including warmup), passed to
\code{R2jags::jags()} or \code{R2jags::jags.parallel()}.
See the argument documentation of the
\code{R2jags::jags()} and \code{R2jags::jags.parallel()} help files for details.}

\item{n.burnin}{Number of warmup iterations, passed to
\code{R2jags::jags()} or \code{R2jags::jags.parallel()}.
See the argument documentation of the
\code{R2jags::jags()} and \code{R2jags::jags.parallel()} help files for details.}

\item{n.thin}{Thinning interval, passed to
\code{R2jags::jags()} or \code{R2jags::jags.parallel()}.
See the argument documentation of the
\code{R2jags::jags()} and \code{R2jags::jags.parallel()} help files for details.}

\item{jags.module}{Character vector of JAGS modules to load, passed to
\code{R2jags::jags()} or \code{R2jags::jags.parallel()}.
See the argument documentation of the
\code{R2jags::jags()} and \code{R2jags::jags.parallel()} help files for details.}

\item{RNGname}{Choice of random number generator, passed to
\code{R2jags::jags()} or \code{R2jags::jags.parallel()}.
See the argument documentation of the
\code{R2jags::jags()} and \code{R2jags::jags.parallel()} help files for details.}

\item{jags.seed}{Seeds to apply to JAGS, passed to
\code{R2jags::jags()} or \code{R2jags::jags.parallel()}.
See the argument documentation of the
\code{R2jags::jags()} and \code{R2jags::jags.parallel()} help files for details.}

\item{stdout}{Character of length 1, file path to write the stdout stream
of the model when it runs. Set to \code{NULL} to print to the console.
Set to \code{R.utils::nullfile()} to suppress stdout.
Does not apply to messages, warnings, or errors.}

\item{stderr}{Character of length 1, file path to write the stderr stream
of the model when it runs. Set to \code{NULL} to print to the console.
Set to \code{R.utils::nullfile()} to suppress stderr.
Does not apply to messages, warnings, or errors.}

\item{progress.bar}{Type of progress bar, passed to
\code{R2jags::jags()} or \code{R2jags::jags.parallel()}.
See the argument documentation of the
\code{R2jags::jags()} and \code{R2jags::jags.parallel()} help files for details.}

\item{refresh}{Frequency for refreshing the progress bar, passed to
\code{R2jags::jags()} or \code{R2jags::jags.parallel()}.
See the argument documentation of the
\code{R2jags::jags()} and \code{R2jags::jags.parallel()} help files for details.}
}
\value{
An \code{R2jags} output object.
}
\description{
Not a user-side function. Do not invoke directly.
}
\keyword{internal}
