% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jewel_inner.R
\name{jewel_inner}
\alias{jewel_inner}
\title{Estimate Gaussian graphical models from multiple datasets}
\usage{
jewel_inner(
  X,
  lambda1,
  lambda2 = NULL,
  Theta = NULL,
  W = NULL,
  tol = 0.01,
  maxIter = 10000,
  verbose = TRUE
)
}
\arguments{
\item{X}{a list of \code{K} numeric data matrices of \code{n_k} samples and \code{p} variables (\code{n_k} can be different for each matrix).}

\item{lambda1}{a number, first regularization parameter (of the common penalty).}

\item{lambda2}{an optional number, second regularization parameter (of the class-specific penalty). If NULL, set to \code{lambda_2 = lambda_1 * 1.4}}

\item{Theta}{an optional list of \code{K} regression coefficient matrices of the size \code{p} by \code{p}. User-provided initialization can be used for warm-start procedures. If NULL, initialized as all zeros.}

\item{W}{an optional list of \code{K} weights matrices of the size \code{p} by \code{p}. User-provided initialization can be used when some vertices are believed to be hubs. If NULL, initialized as all ones.}

\item{tol}{an optional number, convergence threshold controlling the relative error between iterations. The default value is 0.01.}

\item{maxIter}{an optional number, maximum allowed number of iterations. The default value is 10 000.}

\item{verbose}{if verbose = FALSE, tracing information printing is disabled. The default value is TRUE.}
}
\value{
The following list is returned
\itemize{
  \item \code{CommonG} - an adjacency matrix of the common estimated graph (intersection of \code{K} estimated graphs).
  \item \code{G_list} - a list of \code{K} adjacency matrices for each estimated graph.
  \item \code{Theta} - a list of \code{K} estimated covariance matrices.
  \item \code{BIC} – a number, value of Bayesian information criterion for resulting graphs.
}
}
\description{
This function estimates Gaussian graphical models (i.e. networks of conditional dependencies, direct connections between variables) given several datasets. 
We assume that datasets contain measurements of the same variables collected under different conditions (different equipment, locations, even sub-types of disease).
}
\keyword{internal}
