% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04_tools.R
\name{idigamma}
\alias{idigamma}
\title{Inverse Digamma Function}
\usage{
idigamma(x, ...)
}
\arguments{
\item{x}{numeric. The point to evaluate the function.}

\item{...}{extra arguments passed to \code{optim()}.}
}
\value{
numeric. The evaluated function.
}
\description{
The inverse of the digamma function, i.e. the derivative of the log-gamma
function.
}
\details{
The \code{idigamma()} function implements the inverse of the digamma function
\eqn{\psi}. It is a numerical approximation based on the Brent optimization
algorithm. Specifically, \code{idigamma()} makes a call to \code{optim()} in order to
solve the equation \eqn{\psi(x) = y}; more accurately, to find the minimum of
\eqn{f(x) = \log\Gamma(x) - xy}, whose derivative is
\eqn{f'(x) = \psi(x) - y}. The optimization is restricted within the tight
bounds derived by Batir (2017). The function is vectorized.
}
\examples{
\donttest{
idigamma(2)
}
}
\references{
Necdet Batir (2017), INEQUALITIES FOR THE INVERSES OF THE POLYGAMMA FUNCTIONS
https://arxiv.org/pdf/1705.06547

Oikonomidis, I. & Trevezas, S. (2023), Moment-Type Estimators for the
Dirichlet and the Multivariate Gamma Distributions, arXiv,
https://arxiv.org/abs/2311.15025
}
\seealso{
\code{\link[=optim]{optim()}}
}
