% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{fit_generator}
\alias{fit_generator}
\title{(Deprecated) Fits the model on data yielded batch-by-batch by a generator.}
\usage{
fit_generator(
  object,
  generator,
  steps_per_epoch,
  epochs = 1,
  verbose = getOption("keras.fit_verbose", default = 1),
  callbacks = NULL,
  view_metrics = getOption("keras.view_metrics", default = "auto"),
  validation_data = NULL,
  validation_steps = NULL,
  class_weight = NULL,
  max_queue_size = 10,
  workers = 1,
  initial_epoch = 0
)
}
\arguments{
\item{object}{Keras model object}

\item{generator}{A generator (e.g. like the one provided by
\code{\link[=flow_images_from_directory]{flow_images_from_directory()}} or a custom R
\href{https://rstudio.github.io/reticulate/articles/calling_python.html#generators-1}{generator function}).

The output of the generator must be a list of one of these forms:

\if{html}{\out{<div class="sourceCode">}}\preformatted{ - (inputs, targets)
 - (inputs, targets, sample_weights)
}\if{html}{\out{</div>}}

This list (a single output of the generator) makes a single batch.
Therefore, all arrays in this list must have the same length (equal to
the size of this batch). Different batches may have different sizes.
For example, the last batch of the epoch is commonly smaller than the
others, if the size of the dataset is not divisible by the batch size.
The generator is expected to loop over its data indefinitely. An epoch
finishes when \code{steps_per_epoch} batches have been seen by the model.}

\item{steps_per_epoch}{Total number of steps (batches of samples) to yield
from \code{generator} before declaring one epoch finished and starting the next
epoch. It should typically be equal to the number of samples if your
dataset divided by the batch size.}

\item{epochs}{Integer. Number of epochs to train the model.
An epoch is an iteration over the entire data provided, as defined by
\code{steps_per_epoch}. Note that in conjunction with \code{initial_epoch},
\code{epochs} is to be understood as "final epoch". The model is not trained
for a number of iterations given by \code{epochs}, but merely until the epoch
of index \code{epochs} is reached.}

\item{verbose}{Verbosity mode (0 = silent, 1 = progress bar, 2 = one line
per epoch). Defaults to 1 in most contexts, 2 if in knitr render or running
on a distributed training server.}

\item{callbacks}{List of callbacks to apply during training.}

\item{view_metrics}{View realtime plot of training metrics (by epoch). The
default (\code{"auto"}) will display the plot when running within RStudio,
\code{metrics} were specified during model \code{\link[=compile]{compile()}}, \code{epochs > 1} and
\code{verbose > 0}. Use the global \code{keras.view_metrics} option to establish a
different default.}

\item{validation_data}{this can be either:
\itemize{
\item a generator for the validation data
\item a list (inputs, targets)
\item a list (inputs, targets, sample_weights).
on which to evaluate
the loss and any model metrics at the end of each epoch.
The model will not be trained on this data.
}}

\item{validation_steps}{Only relevant if \code{validation_data} is a generator.
Total number of steps (batches of samples) to yield from \code{generator} before
stopping at the end of every epoch. It should typically be equal to the number
of samples of your validation dataset divided by the batch size.}

\item{class_weight}{Optional named list mapping class indices (integer) to a
weight (float) value, used for weighting the loss function (during
training only). This can be useful to tell the model to "pay more
attention" to samples from an under-represented class.}

\item{max_queue_size}{Maximum size for the generator queue. If unspecified,
\code{max_queue_size} will default to 10.}

\item{workers}{Maximum number of threads to use for parallel processing. Note that
parallel processing will only be performed for native Keras generators (e.g.
\code{flow_images_from_directory()}) as R based generators must run on the main thread.}

\item{initial_epoch}{epoch at which to start training (useful for resuming a
previous training run)}
}
\value{
Training history object (invisibly)
}
\description{
The generator is run in parallel to the model, for efficiency. For instance,
this allows you to do real-time data augmentation on images on CPU in
parallel to training your model on GPU.
}
\seealso{
Other model functions: 
\code{\link{compile.keras.engine.training.Model}()},
\code{\link{evaluate.keras.engine.training.Model}()},
\code{\link{evaluate_generator}()},
\code{\link{fit.keras.engine.training.Model}()},
\code{\link{get_config}()},
\code{\link{get_layer}()},
\code{\link{keras_model}()},
\code{\link{keras_model_sequential}()},
\code{\link{multi_gpu_model}()},
\code{\link{pop_layer}()},
\code{\link{predict.keras.engine.training.Model}()},
\code{\link{predict_generator}()},
\code{\link{predict_on_batch}()},
\code{\link{predict_proba}()},
\code{\link{summary.keras.engine.training.Model}()},
\code{\link{train_on_batch}()}
}
\concept{model functions}
\keyword{internal}
