% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dens.net.heat.R
\name{dens.net.heat}
\alias{dens.net.heat}
\title{Adaptive linear network intensity estimator based on heat kernel}
\usage{
dens.net.heat(
  X,
  ...,
  weights = NULL,
  bw = NULL,
  ngroups = NULL,
  at = c("pixels", "points")
)
}
\arguments{
\item{X}{A point pattern on a linear network (an object of class \code{lpp}) to be smoothed.}

\item{...}{Extra arguments passed to \link[spatstat.linnet]{densityHeat.lpp}.}

\item{weights}{Optional. Numeric vector of weights associated with the points of X. Weights can be positive, negative or zero.}

\item{bw}{Numeric vector of spatial smoothing bandwidths for each point in \code{X}. By default this is computed using \link[spatstat.univar]{bw.abram}.}

\item{ngroups}{Number of groups in which the bandwidths should be partitioned. If this number is 1, then a classical non-adaptive estimator will be used for the spatial part with a bandwidth selected as the median of the bw.xy vector.}

\item{at}{String specifying whether to estimate the intensity at a mesh (\code{at = "pixels"}) or only at the points of \code{X} (\code{at = "points"}).}
}
\value{
If \code{at = "points"} (the default), the result is a numeric vector with one entry for each data point in \code{X}. if \code{at = "pixels"} is a pixel image on a linear network (\link[spatstat.linnet]{linim} objects) corresponding to the intensity over linear network.
}
\description{
Provides an adaptive-bandwidth kernel estimate for point patterns on linear networks by using binning of the bandwidth values.
}
\details{
This function computes an adaptive kernel estimate of the intensity on linear networks. It starts from a point pattern \code{X} and partition the component to apply a kernel estimator within each cell.
The argument \code{bw} specifies the smoothing bandwidth vector to be applied to each of the points in \code{X}. It should be a numeric vector of bandwidths.
The method partition the range of bandwidths into intervals, subdividing the points of the pattern \code{X} into sub-patterns according to the bandwidths, and applying fixed-bandwidth smoothing to each sub-pattern. Specifying \code{ngroups = 1} is the same as fixed-bandwidth smoothing with bandwidth \code{sigma = median(bw)}.
}
\references{
González J.A. and Moraga P. (2018)
An adaptive kernel estimator for the intensity function of spatio-temporal point processes
\url{http://arxiv.org/pdf/2208.12026}
}
\author{
Jonatan A. González
}
