% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combine_results.R
\name{combine_results}
\alias{combine_results}
\title{Combine results of permutation test for keyness}
\usage{
combine_results(results_1, results_2)
}
\arguments{
\item{results_1}{Results from permutation test.
Must be of class \code{keyperm_results_counts} 
(obtained by setting \code{output = "counts"} in \code{keyperm()})}

\item{results_2}{Results from permutation test.
Must be of class \code{keyperm_results_counts} and have the same scoretype as
\code{results_1}.}
}
\value{
An object of class \code{keyperm_results_counts}
}
\description{
Combine results of two runs of \code{keyperm()} with 
\code{output = "counts"}, possibly with different subsets of terms.
}
\details{
Results of two runs of \code{keyperm()} with \code{output = "counts"}, i.e. objects of
type \code{keyperm_results_counts} using can be combined 
using \code{combine_results()}. For this to make sense, \code{scoretype} needs to be 
the same in both results, but terms in both objects need not be the same.

There are at least two important uses of the function:

Parallelization: \code{keyperm()} is run several times with the same parameters 
on different cores, using \code{parallel::mclapply()} or a similar function.

Screening runs: \code{keyperm()} is first run using a small to medium number of permutations,
but considering all terms. Terms with p-values clearly exceeding some reasonable 
significance threshold are then excluded, and \code{keyperm()} is run a second time with a 
(preferably) large number of permutations but using only the remaining terms. The results of
both runs can then be combined into one object. The rationale behind this approach is that 
in many cases small p-values need to be determined with much greater accurary than larger ones
far away from significance, especially if a correction for multiple testing is to be applied 
or the p-values are used for ranking (although they should not...).
}
