% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_data_elements_with_category_options.R
\name{get_data_elements_with_category_options}
\alias{get_data_elements_with_category_options}
\title{Get Data Elements with Category Options}
\usage{
get_data_elements_with_category_options(
  element_ids,
  auth = NULL,
  call = caller_env()
)
}
\arguments{
\item{element_ids}{The data element identifiers whose details being retrieved}

\item{auth}{The authentication object}

\item{call}{The caller environment}
}
\value{
A tibble containing the following columns:
\itemize{
\item element_id - The unique identifier for the data element.
\item element    - The name of the data element.
\item category   - The category options for the elements
\item category_id - The unique identifier for the category options
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
\code{get_data_elements_with_category_options()} fetches data elements metadata with the
category options from the DHIS2 API server.
}
\examples{
\dontshow{if (khis_has_cred()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

# Fetch the data element metadata for particular element id
elements <- get_data_elements_with_category_options('htFuvGJRW1X')
elements
\dontshow{\}) # examplesIf}
}
