% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calPWM.R
\name{calPWM}
\alias{calPWM}
\title{Calculate position weight matrix of overlapping sequences.
Simulation of human population is based on single nucleotide variation.}
\usage{
calPWM(
  kmers,
  pseudo.num = 0,
  bg.prop = c(a = 0.295, c = 0.205, g = 0.205, t = 0.295),
  output = "PWM"
)
}
\arguments{
\item{kmers}{A vector of k-mers to overlap.}

\item{pseudo.num}{Pseudo-number to avoid numerical instability due to lack of
base at a position. Default is zero i.e. no pseudo-number.}

\item{bg.prop}{Background proportion of bases. Default is c(a = 0.295,
c = 0.205, g = 0.205, t = 0.295) which is observed in human genome.}

\item{output}{Output matrix type. Options are PCM, PPM, and PWM which refer
to position count/probability/weight matrix. Default is PWM.}
}
\value{
A position count/probability/weight matrix.
}
\description{
Calculate position weight matrix of overlapping sequences.
Simulation of human population is based on single nucleotide variation.
}
