% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/knn_forecast.R
\name{knn_forecast}
\alias{knn_forecast}
\title{Predicts next value of the time series using k-nearest neighbors algorithm.}
\usage{
knn_forecast(
  y,
  k,
  d,
  distance = "euclidean",
  weight = "proportional",
  v = 1,
  threads = 1,
  h = 1
)
}
\arguments{
\item{y}{A time series or a trained kNN model generated by the
knn_param_search_function. In case that a model is provided the rest of
parameters will be ignored and all of them will be taken from the model.}

\item{k}{Number of neighbors.}

\item{d}{Length of each of the 'elements'.}

\item{distance}{Type of metric to evaluate the distance between points. Many
metrics are supported: euclidean, manhattan, dynamic time warping, camberra
and others. For more information about the supported metrics check the
values that 'method' argument of function parDist (from parallelDist
package) can take as this is the function used to calculate the distances.
Link to package info: https://cran.r-project.org/web/packages/parallelDist
Some of the values that this argument can take are "euclidean", "manhattan",
"dtw", "camberra", "chord".}

\item{weight}{Type of weight to be used at the time of calculating the
predicted value with a weighted mean. Three supported: proportional,
average, linear.
\describe{
  \item{proportional}{the weight assigned to each neighbor is inversely
  proportional to its distance}
  \item{average}{all neighbors are assigned with the same weight}
  \item{linear}{nearest neighbor is assigned with weight k, second closest
  neighbor with weight k-1, and so on until the least nearest neighbor which
  is assigned with a weight of 1.}
}}

\item{v}{Variable to be predicted if given multivariate time series.}

\item{threads}{Number of threads to be used when parallelizing, default is 1}

\item{h}{Temporal horizon of the prediction (only value 1 is implemented).
This parameter is present only for compatibility with the forecast package.}
}
\value{
The predicted value.
}
\description{
Predicts next value of the time series using k-nearest neighbors algorithm.
}
\examples{
knn_forecast(AirPassengers, 5, 2)
knn_forecast(LakeHuron, 3, 6)
}
