% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_mats.R
\name{SpMatrixCalc}
\alias{SpMatrixCalc}
\title{Calculate Seasonal Similarity Matrix}
\usage{
SpMatrixCalc(v, nPeriods)
}
\arguments{
\item{v}{positive numeric vector with the seasonal periods corresponding to each point in the response series.}

\item{nPeriods}{positive numeric value representing the maximum value \code{v} can take on.}
}
\value{
numeric matrix of seasonal similarities for the vector \code{v}.
}
\description{
Generates and returns an n x n matrix by calculating the seasonal dissimilarity
for each possible pair of points in a vector
of seasonal periods, then converts dissimilarity matrix to a similarity matrix using 1 / (D_p + 1).
}
\examples{
SpMatrixCalc(c(1, 2, 4), 4)
}
\seealso{
\itemize{
\item Trupiano (2021) arXiv:2112.06266 for information on the formulation of this seasonal similarity measure.
\item \code{\link[=SeasonalAbsDissimilarity]{SeasonalAbsDissimilarity()}} for the function used to calculate seasonal dissimilarity.
}
}
