% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{simulation_master_list}
\alias{simulation_master_list}
\title{simulation_master_list}
\format{
A list containing 20 sublists each with 31 items:
\describe{
          \item{series.len}{the number of observations in the simulated time series}
          \item{random.seed}{the random seed used in \code{set.seed()} for all random components in the sublist.}
          \item{arima.p}{The AR order argument for \code{stats::arima.sim()}.}
          \item{arima.d}{The differencing order argument for \code{stats::arima.sim()}.}
          \item{arima.q}{The MA order argument for \code{stats::arima.sim()}.}
          \item{ar.coefficients}{Coefficients for the AR process in \code{stats::arima.sim()},\code{NULL} if \code{arima.p=0}.}
          \item{ma.coefficients}{Coefficients for the MA process in \code{stats::arima.sim()},\code{NULL} if \code{arima.q=0}.}
          \item{seasonal.periods}{The number of periods in a full cycle for the periodic component of the series.}
          \item{sin.coef}{Coefficient on the sin term of the periodic component of the series.}
          \item{cos.coef}{Coefficient on the cos term of the periodic component of the series.}
          \item{X.cols}{Number of predictors used to generate the f(x) component of \code{series.mvnormx}.}
          \item{X.mu}{The mean vector used in \code{MASS::mvrnorm()} to generate \code{X} for the f(x) component of \code{series.mvnormx}.}
          \item{X.Sigma}{The covariance matrix generated by \code{clusterGeneration::rcorrmatrix()} used in \code{MASS::mvrnorm()} to generate \code{X} for the f(x) component of \code{series.mvnormx}.}
          \item{X}{The matrix of \code{X.cols} predictors generated by \code{MASS::mvrnorm()} used to generate the f(x) component of \code{series.mvnormx}.}
          \item{x.coef}{The vector of \code{X.cols} coefficients corresponding to the predictors of \code{X} used to generate the f(x) component of \code{series.mvnormx}.}
          \item{x.chng.mu}{The mean value used in \code{stats::rnorm()} used to generate \code{x.chng}.}
          \item{x.chng.sd}{The standard deviation value used in \code{stats::rnorm()} used to generate \code{x.chng}.}
          \item{x.chng.coef1}{A coefficient for \code{x.chng} used in all piece-wise functional relationship, f(x), components, as the \code{coef} argument to \code{lin.to.sqrt()} and \code{quad.to.cubic}
           and the \code{coef1} argument to \code{ lin.coef.change }.}
          \item{x.chng.coef2}{A coefficient for \code{x.chng} used in the piece-wise functional relationship, f(x), component of \code{series.lin.coef.chng.x}, as the \code{coef2} argument to \code{ lin.coef.change }.}
          \item{x.chng.break.point}{A value used in two piece-wise functional relationship, f(x), components, as the \code{break.point} argument to \code{quad.to.cubic} and \code{ lin.coef.change }.}
          \item{x.chng.break.point.sqrt}{The \code{max()} of \code{x.chng.break.point} and some value > 0. Used in the piece-wise functional relationship, f(x), component of \code{series.lin.to.sqrt.x} , as the \code{break.point} argument to \code{lin.to.sqrt}.}
          \item{x.chng}{A vector of observations of a single predictor used to generate the f(x) component of all series other than \code{series.mvnormx}.}
          \item{type.noise}{The family of probability distributions to to generate the additional noise component.}
          \item{poisson.rate}{The \code{lambda} argument of \code{stats::rpois()} used to generate additional noise, only actually used if \code{type.noise = 'poisson'}. }
          \item{norma.sd}{The \code{sd} argument of \code{stats::rnorm()} used to generate additional noise, only actually used if \code{type.noise = 'normal'}. }
          \item{constant}{A numeric value which is the constant component of the series.}
          \item{series.mvnormx}{A simulated time series generated from the sum of ARIMA, Periodic, f(x), noise, and constant components. In this case f(x) represents linear relationships to the columns of the matrix \code{X}.  }
          \item{series.lin.to.sqrt.x}{A simulated time series generated from the sum of ARIMA, Periodic, f(x), noise, and constant components. In this case f(x) represents a linear relationship to a single predictor \code{x.chng} which changes to a \code{sqrt(x.chng)}
          relationship when \code{x.chng > x.chng.break.point.sqrt}.}
          \item{series.lin.coef.chng.x}{A simulated time series generated from the sum of ARIMA, Periodic, f(x), noise, and constant components. In this case f(x) represents a linear relationship to a single predictor \code{x.chng} which changes coefficient when
           \code{x.chng > x.chng.break.point}.}
          \item{series.quad.to.cubic.x}{A simulated time series generated from the sum of ARIMA, Periodic, f(x), noise, and constant components. In this case f(x) represents a quadratic relationship to a single predictor \code{x.chng} which changes to a cubic relationship when
          \code{x.chng > x.chng.break.point}, in addition a coefficient changes sign at \code{x.chng.break.point}.}
          }
}
\source{
\url{https://github.com/mtrupiano1/knnwtsim/blob/main/data-raw/simulation_master_list.R}
}
\usage{
simulation_master_list
}
\description{
A list of 20 lists. Each of the 20 lists contains 31 items including 4 simulated time series.
Each series contains an ARIMA component, a periodic component simulated using trig functions, a component determined by a functional relationship
to exogenous predictors which we will call the f(x) component, a constant, and finally additional noise generated from either a
Gaussian distribution with mean = 0, or Poisson distribution. The 4 series within a given sublist only differ based on the f(x) component of the series. One series, \code{series.mvnormx}, uses
a matrix \code{X} generated by \code{MASS::mvrnorm()} with corresponding coefficients for the f(x) component. All other
series use piece-wise functional relationships for the f(x) component of the series.
}
\details{
Below we have the functional relationships used for the piece-wise series:

\code{lin.to.sqrt <- function(x, break.point, coef){
 if (x < break.point) {
  out <- coef * x
} else {
  out <- sqrt(x)
 }
return(out)
 }
}

\code{quad.to.cubic <- function(x, break.point, coef){
 if (x < break.point) {
  out <- coef * (x ** 2)
} else {
  out <- -coef * (x ** 3)
}
return(out)
}
}

\code{ lin.coef.change <- function(x, break.point, coef1, coef2){
if (x < break.point) {
  out <- coef1 * x
} else {
  out <- coef2 * x
}
return(out)
}
}
}
\keyword{datasets}
