% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ko.glm.R
\name{ko.glm}
\alias{ko.glm}
\title{Statistics of the knockoffs procedure for glmnet regression models.}
\usage{
ko.glm(x, y, family = "gaussian", alpha = 1,
  type.gaussian = ifelse(nvars < 500, "covariance", "naive"),
  type.logistic = "Newton", type.multinomial = "ungrouped",
  nVal = 50, random = FALSE)
}
\arguments{
\item{x}{Input matrix, of dimension nobs x nvars; each row is an observation vector. Can be in sparse matrix format (inherit from class "\code{sparseMatrix}" as in package \code{Matrix}; not yet available for \code{family="cox"})}

\item{y}{Response variable. Quantitative for \code{family="gaussian"}, or \code{family="poisson"} (non-negative counts). For family="binomial" should be either a factor with two levels, or a two-column matrix of counts or proportions (the second column is treated as the target class; for a factor, the last level in alphabetical order is the target class). For \code{family="multinomial"}, can be a \code{nc>=2} level factor, or a matrix with \code{nc} columns of counts or proportions. For either \code{"binomial"} or \code{"multinomial"}, if \code{y} is presented as a vector, it will be coerced into a factor. For \code{family="cox"}, \code{y} should be a two-column matrix with columns named 'time' and 'status'. The latter is a binary variable, with '1' indicating death, and '0' indicating right censored. The function \code{Surv()} in package survival produces such a matrix.}

\item{family}{Response type: "gaussian","binomial","poisson","multinomial","cox". Not available for "mgaussian".}

\item{alpha}{The elasticnet mixing parameter, with 0 <= \code{alpha} <= 1. \code{alpha=1} is the lasso penalty, and \code{alpha=0} the ridge penalty. The default is 1.}

\item{type.gaussian}{See \code{glmnet} documentation.}

\item{type.logistic}{See \code{glmnet} documentation.}

\item{type.multinomial}{See \code{glmnet} documentation.}

\item{nVal}{Length of lambda sequence - default is 50.}

\item{random}{If \code{TRUE}, the matrix of knockoffs is different for every run. If \code{FALSE}, a seed is used so that the knockoffs are the same. The default is \code{FALSE}.}
}
\value{
A vector of dimension nvars corresponding to the statistics W.
}
\description{
Returns the vector of statistics W of the revisited knockoffs procedure for regressions available in the R package \code{glmnet}. Most of the parameters come from \code{glmnet()}. See \href{https://CRAN.R-project.org/package=glmnet}{\code{glmnet} documentation} for more details.
}
\examples{
# see ko.sel

}
\seealso{
\code{\link{ko.sel}}
}
