% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download.R
\name{ln_download_data}
\alias{ln_download_data}
\alias{ln_data_downloaded}
\title{Download high-resolution reference distributions}
\usage{
ln_download_data(dir = NULL)

ln_data_downloaded()
}
\arguments{
\item{dir}{the directory to download the data to. If \code{NULL} and the user approves, the data will be downloaded to the package directory, using \code{rappdirs::user_data_dir("labnorm")}, otherwise - a temporary directory would be used.}
}
\value{
None.

True if the data was downloaded, false otherwise.
}
\description{
The data is downloaded to the directory specified by the \code{dir} parameter. Note
that if you specified a directory different from the default, you will need to set \code{options(labNorm.dir = dir)} in order for the package to use the downloaded data in future sessions.
\cr
Default directories are:
\itemize{
\item Unix: ~/.local/share/LabNorm
\item Mac OS X: \verb{~/Library/Application Support/LabNorm}
\item Win XP (not roaming): \verb{C:\\\\Documents and Settings\\\\<username>\\\\Data\\\\<AppAuthor>\\\\LabNorm}
\item Win XP (roaming): \verb{C:\\\\Documents and Settings\\\\<username>\\\\Local Settings\\\\Data\\\\<AppAuthor>\\\\LabNorm}
\item Win 7 (not roaming): \verb{C:\\\\Users\\\\<username>\\\\AppData\\\\Local\\\\<AppAuthor>\\\\LabNorm}
\item Win 7 (roaming): \verb{C:\\\\Users\\\\<username>\\\\AppData\\\\Roaming\\\\<AppAuthor>\\\\LabNorm}
}
}
\examples{
\donttest{
ln_download_data()
}

ln_data_downloaded()

}
