% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{response_prop}
\alias{response_prop}
\title{Calculate Response Proportions}
\usage{
response_prop(data, n_levels)
}
\arguments{
\item{data}{numeric vector or matrix of responses.}

\item{n_levels}{number of response categories.}
}
\value{
A table of response category proportions.
}
\description{
Returns a table of proportions for each possible response category.
}
\examples{
data <- c(1, 2, 2, 3, 3, 3)
response_prop(data, n_levels = 3)

data_matrix <- matrix(c(1, 2, 2, 3, 3, 3), ncol = 2)
response_prop(data_matrix, n_levels = 3)
}
