% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{plot-lcModel-method}
\alias{plot-lcModel-method}
\alias{plot,lcModel,ANY-method}
\alias{plot,lcModel-method}
\title{Plot a lcModel}
\usage{
\S4method{plot}{lcModel}(x, y, ...)
}
\arguments{
\item{x}{The \code{lcModel} object.}

\item{y}{Not used.}

\item{...}{
  Arguments passed on to \code{\link[=plotClusterTrajectories]{plotClusterTrajectories}}
  \describe{
    \item{\code{object}}{The (cluster) trajectory data.}
  }}
}
\value{
A \code{ggplot} object.
}
\description{
Plot a \code{lcModel} object.
By default, this plots the cluster trajectories of the model, along with the trajectories used for estimation.
}
\examples{
data(latrendData)
method <- lcMethodLMKM(Y ~ Time, id = "Id", time = "Time")
model <- latrend(method, latrendData, nClusters = 3)

if (require("ggplot2")) {
  plot(model)
}
}
\seealso{
\link{plotClusterTrajectories} \link{plotFittedTrajectories} \link{plotTrajectories} \link[ggplot2:ggplot]{ggplot2::ggplot}

Other lcModel functions: 
\code{\link{clusterNames}()},
\code{\link{clusterProportions}()},
\code{\link{clusterSizes}()},
\code{\link{clusterTrajectories}()},
\code{\link{coef.lcModel}()},
\code{\link{converged}()},
\code{\link{deviance.lcModel}()},
\code{\link{df.residual.lcModel}()},
\code{\link{estimationTime}()},
\code{\link{externalMetric}()},
\code{\link{fitted.lcModel}()},
\code{\link{fittedTrajectories}()},
\code{\link{getCall.lcModel}()},
\code{\link{getLcMethod}()},
\code{\link{ids}()},
\code{\link{lcModel-class}},
\code{\link{metric}()},
\code{\link{model.frame.lcModel}()},
\code{\link{nClusters}()},
\code{\link{nIds}()},
\code{\link{nobs.lcModel}()},
\code{\link{plotClusterTrajectories}()},
\code{\link{plotFittedTrajectories}()},
\code{\link{postprob}()},
\code{\link{predict.lcModel}()},
\code{\link{predictAssignments}()},
\code{\link{predictForCluster}()},
\code{\link{predictPostprob}()},
\code{\link{qqPlot}()},
\code{\link{residuals.lcModel}()},
\code{\link{sigma.lcModel}()},
\code{\link{strip}()},
\code{\link{time.lcModel}()},
\code{\link{trajectoryAssignments}()}
}
\concept{lcModel functions}
