% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.LDABatch.R
\name{as.LDABatch}
\alias{as.LDABatch}
\alias{is.LDABatch}
\title{LDABatch Constructor}
\usage{
as.LDABatch(reg, job, id)

is.LDABatch(obj, verbose = FALSE)
}
\arguments{
\item{reg}{[\code{\link[batchtools:makeRegistry]{Registry}}]\cr
Registry. See \code{\link[batchtools:findJobs]{findDone}}.}

\item{job}{[\code{\link{data.frame}} or \code{integer}]\cr
A data.frame or data.table with a column named "job.id" or a vector of integerish job ids.
See \code{\link[batchtools]{reduceResultsList}}.}

\item{id}{[\code{character(1)}]\cr
A name for the registry. If not passed, the folder's name is extracted from \code{reg}.}

\item{obj}{[\code{R} object]\cr
Object to test.}

\item{verbose}{[\code{logical(1)}]\cr
Should test information be given in the console?}
}
\value{
[\code{named list}] with entries \code{id} for the registry's folder name,
\code{jobs} for the submitted jobs' ids and its parameter settings and
\code{reg} for the registry itself.
}
\description{
Constructs a \code{\link{LDABatch}} object for given elements \code{reg},
\code{job} and \code{id}.
}
\details{
Given a \code{\link[batchtools:makeRegistry]{Registry}} the function returns
a \code{\link{LDABatch}} object, which can be handled using the getter functions
at \code{\link{getJob}}.
}
\examples{
\dontrun{
batch = LDABatch(docs = reuters_docs, vocab = reuters_vocab, K = 15, chunk.size = 20)
batch

batch2 = as.LDABatch(reg = getRegistry(batch))
batch2
head(getJob(batch2))

batch3 = as.LDABatch()
batch3

### one way of loading an existing registry ###
batchtools::loadRegistry("LDABatch")
batch = as.LDABatch()
}

}
\seealso{
Other constructor functions: 
\code{\link{LDA}()},
\code{\link{as.LDARep}()}

Other batch functions: 
\code{\link{LDABatch}()},
\code{\link{getJob}()},
\code{\link{mergeBatchTopics}()}
}
\concept{batch functions}
\concept{constructor functions}
