% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ldhmm-gamma_init.R
\name{ldhmm.gamma_init}
\alias{ldhmm.gamma_init}
\title{Initializing tansition probability paramter}
\usage{
ldhmm.gamma_init(m, p1 = 0.04, p2 = 0.01, prob = NULL, min.gamma = 0)
}
\arguments{
\item{m}{numeric, number of states}

\item{p1}{numeric, the first-neighbor transition probability, default is 0.04.}

\item{p2}{numeric, the second-neighbor transition probability, default is 0.01.}

\item{prob}{numeric or matrix, a fully specified transition probability by user, default is \code{NULL}.
If this is specified, p1, p2 would be ignored.}

\item{min.gamma}{numeric, a minimum transition probability added to gamma to avoid singularity, default is 0.
This is only used when \code{prob} is not \code{NULL}.}
}
\value{
a matrix as gamma
}
\description{
This utility has multiple purposes. It can generate a simple transition probability matrix, 
using p1 and p2, if prob is left as NULL. The generated gamma is raw and not normalized.
If prob is provided as a vector, the utility converts it into a matrix as gamma.
Furthermore, if prob is provided as a vector or matrix, the utility 
applies \code{min.gamma}, and normalize the sum of t.p.m. rows to 1.
This is mainly an internal function used by MLE, not be concerned by external users.
}
\examples{
  gamma0 <- ldhmm.gamma_init(m=3)
  prob=c(0.9, 0.1, 0.1, 
         0.1, 0.9, 0.0,
         0.1, 0.1, 0.8)
  gamma1 <- ldhmm.gamma_init(m=3, prob=prob)
  gamma2 <- ldhmm.gamma_init(m=2, prob=gamma1, min.gamma=1e-6)

}
\author{
Stephen H. Lihn
}
\keyword{constructor}
