% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_parameters_sc.R
\name{estimate_parameters_sc}
\alias{estimate_parameters_sc}
\title{Estimate parameters of the self-correcting model using log-likelihood optimization}
\usage{
estimate_parameters_sc(
  data,
  x_grid = NULL,
  y_grid = NULL,
  t_grid = NULL,
  parameter_inits = NULL,
  upper_bounds = NULL,
  opt_algorithm = "NLOPT_LN_SBPLX",
  nloptr_options = list(maxeval = 400, xtol_rel = 1e-05, maxtime = NULL),
  verbose = TRUE
)
}
\arguments{
\item{data}{a matrix or data frame of times and locations in the form (time, x, y).}

\item{x_grid}{a vector of grid values for x.}

\item{y_grid}{a vector of grid values for y.}

\item{t_grid}{a vector of grid values for t.}

\item{parameter_inits}{a vector of parameter initialization values.}

\item{upper_bounds}{a vector of upper bounds for time, x, and y.}

\item{opt_algorithm}{the NLopt algorithm to use for optimization.}

\item{nloptr_options}{a list of named options for [nloptr::nloptr()] including "maxeval", "xtol_rel", and "maxtime".}

\item{verbose}{`TRUE` or `FALSE` indicating whether to show progress of optimization.}
}
\value{
an [nloptr::nloptr()] object with details of the optimization including solution.
}
\description{
Estimate the parameters of the self-correcting model using the [nloptr::nloptr()] function given a formatted dataset.
}
\details{
This function estimates the parameters of the self-correcting model presented in Møller et al. (2016) using the full likelihood.
Details regarding the self-correcting model and the estimation procedure can be found in the references.
}
\examples{
# Load the small example data
data(small_example_data)
small_example_data <- small_example_data \%>\%
  dplyr::mutate(time = power_law_mapping(size, .5)) \%>\%
  dplyr::select(time, x, y)

# Define the grid values
x_grid <- seq(0, 25, length.out = 5)
y_grid <- seq(0, 25, length.out = 5)
t_grid <- seq(0, 1, length.out = 5)

# Define the parameter initialization values
parameter_inits <- c(1.5, 8.5, .015, 1.5, 3.2, .75, 3, .08)

# Define the upper bounds
upper_bounds <- c(1, 25, 25)

# Estimate the parameters
estimate_parameters_sc(
  data = small_example_data,
  x_grid = x_grid,
  y_grid = y_grid,
  t_grid = t_grid,
  parameter_inits = parameter_inits,
  upper_bounds = upper_bounds,
  opt_algorithm = "NLOPT_LN_SBPLX",
  nloptr_options = list(
    maxeval = 25,
    xtol_rel = 1e-2
  ),
  verbose = TRUE
)

}
\references{
Møller, J., Ghorbani, M., & Rubak, E. (2016). Mechanistic spatio-temporal point process models
for marked point processes, with a view to forest stand data. \emph{Biometrics}, 72(3), 687–696.
\doi{10.1111/biom.12466}.
}
