% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmtiles.R
\name{addPMPolygons}
\alias{addPMPolygons}
\alias{addPMPoints}
\alias{addPMPolylines}
\title{Add vector tiles stored as PMTiles in an AWS S3 bucket to a leaflet map.}
\usage{
addPMPolygons(
  map,
  url,
  style,
  layerId = NULL,
  group = NULL,
  pane = "overlayPane",
  attribution = NULL
)

addPMPoints(
  map,
  url,
  style,
  layerId = NULL,
  group = NULL,
  pane = "overlayPane",
  attribution = NULL
)

addPMPolylines(
  map,
  url,
  style,
  layerId = NULL,
  group = NULL,
  pane = "overlayPane",
  attribution = NULL
)
}
\arguments{
\item{map}{the map to add to.}

\item{url}{the url to the tiles to be served.}

\item{style}{styling for the layer. See \link{paintRules} for details.}

\item{layerId}{the layer id.}

\item{group}{group name.}

\item{pane}{the map pane to which the layer should be added. See
\link[leaflet]{addMapPane} for details.}

\item{attribution}{optional attribution character string.}
}
\description{
Add vector tiles stored as PMTiles in an AWS S3 bucket to a leaflet map.

Add point data stored as PMTiles

Add polylines stored as PMTiles
}
\details{
These functions can be used to add cloud optimized vector tiles data in
the \code{.pmtiles} format stored in an Amazon Web Services (AWS) S3 bucket to a
leaflet map. For instructions on how to create these files, see
\url{https://github.com/protomaps/PMTiles}.

NOTE: You may not see the tiles rendered in the RStudio viewer pane. Make
sure to open the map in a browser.
}
\section{Functions}{
\itemize{
\item \code{addPMPoints()}: add points stored as PMTiles

\item \code{addPMPolylines()}: add ploylines stored as PMTiles

}}
\examples{
## PMPolygons
library(leaflet)
library(leafem)

url_nzb = "https://vector-tiles-data.s3.eu-central-1.amazonaws.com/nz-building-outlines.pmtiles"

leaflet() \%>\%
  addTiles() \%>\%
  addPMPolygons(
    url = url_nzb
    , layerId = "nzbuildings"
    , group = "nzbuildings"
    , style = paintRules(
      layer = "nz-building-outlines"
      , fillColor = "pink"
      , stroke = "green"
    )
  ) \%>\%
  setView(173.50, -40.80, 6)

## PMPoints
library(leaflet)
library(leafem)

url_depoints = "https://vector-tiles-data.s3.eu-central-1.amazonaws.com/depoints.pmtiles"

leaflet() \%>\%
  addTiles() \%>\%
  addPMPoints(
    url = url_depoints
    , layerId = "depoints"
    , group = "depoints"
    , style = paintRules(
      layer = "depoints"
      , fillColor = "black"
      , stroke = "white"
      , radius = 4
    )
  ) \%>\%
  setView(10, 51, 6)

## PMPolylines
library(leaflet)
library(leafem)

url_rivers = "https://vector-tiles-data.s3.eu-central-1.amazonaws.com/rivers_africa.pmtiles"

## NOTE: these will only render until a zoom level of 7!!
leaflet() \%>\%
  addTiles() \%>\%
  addPMPolylines(
    url = url_rivers
    , layerId = "rivers"
    , group = "rivers"
    , style = paintRules(
      layer = "rivers_africa"
      , color = "blue"
    )
  ) \%>\%
  setView(24, 2.5, 4)

}
