% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scalebar.R
\name{addScaleBar}
\alias{addScaleBar}
\alias{scaleBarOptions}
\alias{removeScaleBar}
\title{Add or remove a scale bar}
\usage{
addScaleBar(
  map,
  position = c("topright", "bottomright", "bottomleft", "topleft"),
  options = scaleBarOptions()
)

scaleBarOptions(
  maxWidth = 100,
  metric = TRUE,
  imperial = TRUE,
  updateWhenIdle = TRUE
)

removeScaleBar(map)
}
\arguments{
\item{map}{the map to add the scale bar to}

\item{position}{position of control: \code{"topleft"}, \code{"topright"}, \code{"bottomleft"}, or
\code{"bottomright"}.}

\item{options}{a list of additional options, intended to be provided by
a call to \code{scaleBarOptions()}}

\item{maxWidth}{maximum width of the control in pixels (default 100)}

\item{metric}{if \code{TRUE} (the default), show a scale bar in metric units
(m/km)}

\item{imperial}{if \code{TRUE} (the default), show a scale bar in imperial
units (ft/mi)}

\item{updateWhenIdle}{if \code{FALSE} (the default), the scale bar is always
up-to-date (updated on \code{move}). If \code{TRUE}, the control is updated
on \code{moveend}.}
}
\description{
Uses Leaflet's built-in
\href{https://web.archive.org/web/20220702182250/https://leafletjs.com/reference-1.3.4.html#control-scale}{scale bar}
feature to add a scale bar.
}
\examples{
\donttest{
leaflet() \%>\%
  addTiles() \%>\%
  addScaleBar()
}

}
