% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{cycle_check}
\alias{cycle_check}
\title{Check Continuity of Life Cycle through Matrices in lefkoMat Objects}
\usage{
cycle_check(mpm, quiet = NULL)
}
\arguments{
\item{mpm}{An object of class lefkoMat, a matrix, or a list of matrices.}

\item{quiet}{A logical variable indicating whether to suppress diagnostic
messages. Defaults to \code{FALSE}.}
}
\value{
Returns a list with two elements, both of which are also lists.
The first list, \code{no_in}, contains as many elements as matrices, with
each element containing an integer vector showing the identification numbers
of stages, stage-pairs, or age-stages, in each matrix that do not show any
transitions leading to them. The second list, \code{no_out}, is structured
similarly to the first, but shows stages, stage-pairs, or age-stages from
which there are no transitions leading out.
}
\description{
Function \code{cycle_check()} tests whether stages, stage-pairs, or
age-stages connect in matrices within \code{lefkoMat} objects.
}
\section{Notes}{

This function tests whether stages, stage-pairs, and age-stages are
connected to others in matrices used for projection. Whether stages,
stage-pairs, or age-stages are shown depends on whether the MPM is
ahistorical / age-based, historical stage-based, or age-by-stage,
respectively. Checks are performed by testing whether each column in a
matrix includes non-zero transitions to other columns, and by testing
whether any columns have no transitions to them from other columns. If any
such columns are found, then function \code{cycle_check}
will export an integer vector giving the column numbers with problems.
These column numbers may then be checked against the \code{stage_id} column
of the associated stageframe in the case of a ahistorical or age-based MPM,
against the row number of the associated \code{hstages} data frame in the
case of a historical MPM, or against the row number of the associated
\code{agestages} data frame in the case of an age-by-stage MPM.
}

\examples{
data(cypdata)

sizevector <- c(0, 0, 0, 0, 0, 0, 1, 2.5, 4.5, 8, 17.5)
stagevector <- c("SD", "P1", "P2", "P3", "SL", "D", "XSm", "Sm", "Md", "Lg",
  "XLg")
repvector <- c(0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1)
obsvector <- c(0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1)
matvector <- c(0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1)
immvector <- c(0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0)
propvector <- c(1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)
indataset <- c(0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1)
binvec <- c(0, 0, 0, 0, 0, 0.5, 0.5, 1, 1, 2.5, 7)

cypframe_raw <- sf_create(sizes = sizevector, stagenames = stagevector,
  repstatus = repvector, obsstatus = obsvector, matstatus = matvector,
  propstatus = propvector, immstatus = immvector, indataset = indataset,
  binhalfwidth = binvec)

cypraw_v1 <- verticalize3(data = cypdata, noyears = 6, firstyear = 2004,
  patchidcol = "patch", individcol = "plantid", blocksize = 4,
  sizeacol = "Inf2.04", sizebcol = "Inf.04", sizeccol = "Veg.04",
  repstracol = "Inf.04", repstrbcol = "Inf2.04", fecacol = "Pod.04",
  stageassign = cypframe_raw, stagesize = "sizeadded", NAas0 = TRUE,
  NRasRep = TRUE)

cypsupp2r <- supplemental(stage3 = c("SD", "P1", "P2", "P3", "SL", "D", 
    "XSm", "Sm", "SD", "P1"),
  stage2 = c("SD", "SD", "P1", "P2", "P3", "SL", "SL", "SL", "rep",
    "rep"),
  eststage3 = c(NA, NA, NA, NA, NA, "D", "XSm", "Sm", NA, NA),
  eststage2 = c(NA, NA, NA, NA, NA, "XSm", "XSm", "XSm", NA, NA),
  givenrate = c(0.10, 0.20, 0.20, 0.20, 0.25, NA, NA, NA, NA, NA),
  multiplier = c(NA, NA, NA, NA, NA, NA, NA, NA, 0.5, 0.5),
  type =c(1, 1, 1, 1, 1, 1, 1, 1, 3, 3),
  stageframe = cypframe_raw, historical = FALSE)

cypmatrix2r <- rlefko2(data = cypraw_v1, stageframe = cypframe_raw, 
  year = "all", patch = "all", stages = c("stage3", "stage2", "stage1"),
  size = c("size3added", "size2added"), supplement = cypsupp2r,
  yearcol = "year2", patchcol = "patchid", indivcol = "individ")

cycle_check(cypmatrix2r)

}
