% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regressors.R
\name{RandomForestRegressor}
\alias{RandomForestRegressor}
\title{RandomForestRegressor}
\value{
R6 Class of RandomForestRegressor
}
\description{
Wrapper R6 Class of randomForest::randomForest function that can be used for LESSRegressor and LESSClassifier
}
\examples{

## ------------------------------------------------
## Method `RandomForestRegressor$new`
## ------------------------------------------------

rf <- RandomForestRegressor$new()
rf <- RandomForestRegressor$new(n_estimators = 500)
rf <- RandomForestRegressor$new(n_estimators = 500, random_state = 100)

## ------------------------------------------------
## Method `RandomForestRegressor$fit`
## ------------------------------------------------

data(abalone)
split_list <- train_test_split(abalone[1:100,], test_size =  0.3)
X_train <- split_list[[1]]
X_test <- split_list[[2]]
y_train <- split_list[[3]]
y_test <- split_list[[4]]

rf <- RandomForestRegressor$new()
rf$fit(X_train, y_train)

## ------------------------------------------------
## Method `RandomForestRegressor$predict`
## ------------------------------------------------

preds <- rf$predict(X_test)
print(head(matrix(c(y_test, preds), ncol = 2, dimnames = (list(NULL, c("True", "Prediction"))))))

## ------------------------------------------------
## Method `RandomForestRegressor$get_estimator_type`
## ------------------------------------------------

rf$get_estimator_type()
}
\seealso{
\code{\link[randomForest:randomForest]{randomForest::randomForest()}}
}
\section{Super classes}{
\code{\link[less:BaseEstimator]{less::BaseEstimator}} -> \code{\link[less:SklearnEstimator]{less::SklearnEstimator}} -> \code{RandomForestRegressor}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-RandomForestRegressor-new}{\code{RandomForestRegressor$new()}}
\item \href{#method-RandomForestRegressor-fit}{\code{RandomForestRegressor$fit()}}
\item \href{#method-RandomForestRegressor-predict}{\code{RandomForestRegressor$predict()}}
\item \href{#method-RandomForestRegressor-get_estimator_type}{\code{RandomForestRegressor$get_estimator_type()}}
\item \href{#method-RandomForestRegressor-clone}{\code{RandomForestRegressor$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="less" data-topic="BaseEstimator" data-id="get_all_fields"><a href='../../less/html/BaseEstimator.html#method-BaseEstimator-get_all_fields'><code>less::BaseEstimator$get_all_fields()</code></a></span></li>
<li><span class="pkg-link" data-pkg="less" data-topic="BaseEstimator" data-id="get_attributes"><a href='../../less/html/BaseEstimator.html#method-BaseEstimator-get_attributes'><code>less::BaseEstimator$get_attributes()</code></a></span></li>
<li><span class="pkg-link" data-pkg="less" data-topic="BaseEstimator" data-id="set_random_state"><a href='../../less/html/BaseEstimator.html#method-BaseEstimator-set_random_state'><code>less::BaseEstimator$set_random_state()</code></a></span></li>
<li><span class="pkg-link" data-pkg="less" data-topic="SklearnEstimator" data-id="get_isFitted"><a href='../../less/html/SklearnEstimator.html#method-SklearnEstimator-get_isFitted'><code>less::SklearnEstimator$get_isFitted()</code></a></span></li>
<li><span class="pkg-link" data-pkg="less" data-topic="SklearnEstimator" data-id="get_type"><a href='../../less/html/SklearnEstimator.html#method-SklearnEstimator-get_type'><code>less::SklearnEstimator$get_type()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RandomForestRegressor-new"></a>}}
\if{latex}{\out{\hypertarget{method-RandomForestRegressor-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of R6 Class of RandomForestRegressor
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RandomForestRegressor$new(
  n_estimators = 100,
  random_state = NULL,
  min_samples_leaf = 1,
  max_leaf_nodes = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n_estimators}}{Number of trees to grow. This should not be set to too small a number,
to ensure that every input row gets predicted at least a few times (defaults to 100).}

\item{\code{random_state}}{Seed number to be used for fixing the randomness (default to NULL).}

\item{\code{min_samples_leaf}}{Minimum size of terminal nodes. Setting this number larger causes smaller trees to be grown
(and thus take less time) (defaults to 1)}

\item{\code{max_leaf_nodes}}{Maximum number of terminal nodes trees in the forest can have.
If not given, trees are grown to the maximum possible (subject to limits by nodesize).
If set larger than maximum possible, a warning is issued. (defaults to NULL)}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{rf <- RandomForestRegressor$new()
rf <- RandomForestRegressor$new(n_estimators = 500)
rf <- RandomForestRegressor$new(n_estimators = 500, random_state = 100)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RandomForestRegressor-fit"></a>}}
\if{latex}{\out{\hypertarget{method-RandomForestRegressor-fit}{}}}
\subsection{Method \code{fit()}}{
Builds a random forest regressor from the training set (X, y).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RandomForestRegressor$fit(X, y)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{X}}{2D matrix or dataframe that includes predictors}

\item{\code{y}}{1D vector or (n,1) dimensional matrix/dataframe that includes response variables}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Fitted R6 Class of RandomForestRegressor
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{data(abalone)
split_list <- train_test_split(abalone[1:100,], test_size =  0.3)
X_train <- split_list[[1]]
X_test <- split_list[[2]]
y_train <- split_list[[3]]
y_test <- split_list[[4]]

rf <- RandomForestRegressor$new()
rf$fit(X_train, y_train)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RandomForestRegressor-predict"></a>}}
\if{latex}{\out{\hypertarget{method-RandomForestRegressor-predict}{}}}
\subsection{Method \code{predict()}}{
Predict regression value for X0.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RandomForestRegressor$predict(X0)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{X0}}{2D matrix or dataframe that includes predictors}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The predict values.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{preds <- rf$predict(X_test)
print(head(matrix(c(y_test, preds), ncol = 2, dimnames = (list(NULL, c("True", "Prediction"))))))
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RandomForestRegressor-get_estimator_type"></a>}}
\if{latex}{\out{\hypertarget{method-RandomForestRegressor-get_estimator_type}{}}}
\subsection{Method \code{get_estimator_type()}}{
Auxiliary function returning the estimator type e.g 'regressor', 'classifier'
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RandomForestRegressor$get_estimator_type()}\if{html}{\out{</div>}}
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{rf$get_estimator_type()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RandomForestRegressor-clone"></a>}}
\if{latex}{\out{\hypertarget{method-RandomForestRegressor-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RandomForestRegressor$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
