% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper-functions.R
\name{laplacian}
\alias{laplacian}
\title{Laplacian kernel - L1 norm}
\usage{
laplacian(data, center, coeff = 0.01)
}
\arguments{
\item{data}{Data that includes points in shape of \strong{(M x d)}}

\item{center}{A constant point in shape of \strong{(1 x d)}}

\item{coeff}{Coefficient value for Laplacian kernel}
}
\value{
A numeric vector containing the laplacian kernel distance between each point in \strong{data} and \strong{center}.
}
\description{
An alternative distance function that can be used in LESS.
}
\examples{
data <- matrix(1:12, nrow=3)
center <- c(2, 7, 1, 3)
distances <- laplacian(data, center)
print(distances)
}
