% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exceeds_tumbling_sum.R
\name{exceeds_tumbling_sum}
\alias{exceeds_tumbling_sum}
\title{Check When the Tumbling Sum of a Vector Exceeds a Threshold}
\usage{
exceeds_tumbling_sum(x, threshold, inclusive = TRUE)
}
\arguments{
\item{x}{a \code{numeric} vector}

\item{threshold}{a \code{numeric} scalar}

\item{inclusive}{a \code{logical} scalar. If \code{TRUE} inclusive bounds are used
(i.e. the threshold is checked with \code{>=}), otherwise exclusive}
}
\value{
a \code{logical} vector of the same length as \code{x} that is \code{TRUE} whenever
\code{threshold} was exceeded and \code{FALSE} otherwise
}
\description{
The tumbling sum is calculated as the partial cumulative sum of a vector
until a threshold is exceeded. Once this happens, the tumbling sum is
calculated from zero again. \code{exceeds_tumbling_sum()} returns \code{TRUE} whenever
this threshold is hit/exceeded and \code{FALSE} otherwise.
}
\details{
This is for example useful if you have high frequency GPS positions
and want to keep only points that are at least \code{x} seconds apart.
}
\examples{
exceeds_tumbling_sum(c(1, 3, 3, 3), 4)
}
\seealso{
\code{\link[MESS:cumsumbinning]{MESS::cumsumbinning()}} does something very similar, but returns
group indices instead of a logical vector.
}
